/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.claim.OasisResponseIF;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import gov.cms.hh.reference.objects.OasisRespondObject;

public class IsValidOasisResponse
extends AbstractSpecification<OasisRespondObject> {
    private final OasisResponseIF response;

    public IsValidOasisResponse(OasisResponseIF response) {
        this.response = response;
    }

    @Override
    public boolean isSatisfiedBy(OasisRespondObject specsResp) {
        if (this.response.getType().name().toUpperCase().startsWith(specsResp.getFieldId().trim().toUpperCase())) {
            int actualValue = -1;
            int specValue = -2;
            try {
                actualValue = Integer.parseInt(this.response.getValue());
                specValue = Integer.parseInt(specsResp.getResponse());
            }
            catch (NullPointerException | NumberFormatException nfe) {
                return false;
            }
            if (actualValue == specValue) {
                return true;
            }
        }
        return false;
    }
}

