/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.common.abstr.DescribableIF;
import gov.cms.hh.common.abstr.IdentifiableIF;
import gov.cms.hh.common.abstr.NameableIF;
import gov.cms.hh.common.abstr.ValuableIF;
import gov.cms.hh.reference.objects.ClinicalGroupObject;
import java.io.Serializable;
import java.text.ParseException;

/**
 *
 * @author CMS
 */
public class ClinicalGroup implements IdentifiableIF, ValuableIF, NameableIF, DescribableIF, Serializable{

    private static final long serialVersionUID = 1L;
    
    @Override
    public String toString() {
        return "ClinicalGroup{" + "id=" + id + ", value=" + value + ", name=" + name + ", description=" + description + ", lowPoints=" + lowPoints + ", highPoints=" + highPoints + '}';
    }

    /**
     * Constructor
     */
    public ClinicalGroup() {
    }

    /**
     *
     * @param id
     * @param value
     * @param name
     * @param description
     * @param lowPoints
     * @param highPoints
     */
    public ClinicalGroup(int id, String value, String name, String description, int lowPoints, int highPoints) {
        this.id = id;
        this.value = value;
        this.name = name;
        this.description = description;
        this.lowPoints = lowPoints;
        this.highPoints = highPoints;
    }

    /**
     *
     * @param id
     * @param cgo
     * @throws ParseException
     */
    public ClinicalGroup(int id, ClinicalGroupObject cgo) throws ParseException {
        this(id,
              cgo.getId(),
              cgo.getName(),
              cgo.getDescription(),
              Integer.parseInt(cgo.getLowPoints()),
              Integer.parseInt(cgo.getHighPoints())
            );
    }
    
    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the name
     */
    @Override
    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    @Override
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return the lowPoints
     */
    public int getLowPoints() {
        return lowPoints;
    }

    /**
     * @param lowPoints the lowPoints to set
     */
    public void setLowPoints(int lowPoints) {
        this.lowPoints = lowPoints;
    }

    /**
     * @return the highPoints
     */
    public int getHighPoints() {
        return highPoints;
    }

    /**
     * @param highPoints the highPoints to set
     */
    public void setHighPoints(int highPoints) {
        this.highPoints = highPoints;
    }
    
    private int id;
    private String value;
    private String name;
    private String description;
    private int lowPoints;
    private int highPoints;

    /**
     * @return the value
     */
    @Override
    public String getValue() {
        return value;
    }

    /**
     * @param value the value to set
     */
    @Override
    public void setValue(String value) {
        this.value = value;
    }
    
}
