/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.reference.objects.ComorbidityGroupObject;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;

/**
 *
 * @author CMS
 */
public class ComorbidityGroup implements ComorbidityGroupIF, Serializable {

    private static final long serialVersionUID = 1L;
    
    /**
     * Constructor
     */
    public ComorbidityGroup() {
    }

    @Override
    public String toString() {
        return "ComorbidityGroup{" + "id=" + id + ", name=" + name + ", description=" + description + ", lowComorbidity=" + lowComorbidity + '}';
    }

    /**
     *
     * @param id
     * @param name
     * @param description
     * @param lowComorbidity
     */
    public ComorbidityGroup(int id, String name, String description, boolean lowComorbidity) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.lowComorbidity = lowComorbidity;
    }

    /**
     *
     * @param id
     * @param cgo
     * @throws ParseException
     */
    public ComorbidityGroup(int id, ComorbidityGroupObject cgo) throws ParseException {
        this(id,
                cgo.getName(),
                cgo.getDescription(),
                Integer.parseInt(cgo.getLowComorbidityFlag()) > 0
        );
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the name
     */
    @Override
    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    @Override
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return the lowComorbidity
     */
    @Override
    public boolean isLowComorbidity() {
        return lowComorbidity;
    }

    /**
     * @param lowComorbidity the lowComorbidity to set
     */
    @Override
    public void setLowComorbidity(boolean lowComorbidity) {
        this.lowComorbidity = lowComorbidity;
    }
    private int id;
    private String name;
    private String description;
    private boolean lowComorbidity;

    /**
     *
     * @return
     */
    @Override
    public boolean isComorbidityPresent() {
        final List<String> INVALID_VALUES = Arrays.asList(
                "", "no_group", "no", "0", "no group"
        );
        return !INVALID_VALUES.contains(name.toLowerCase().trim());
    }
}
