/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.common.abstr.DescribableIF;
import gov.cms.hh.common.abstr.IdentifiableIF;
import gov.cms.hh.common.abstr.NameableIF;

/**
 *
 * @author CMS
 */
public interface ComorbidityGroupIF extends DescribableIF, IdentifiableIF, NameableIF {

    /**
     * @return the description
     */
    @Override
    String getDescription();

    /**
     * @return the id
     */
    @Override
    int getId();

    /**
     * @return the name
     */
    @Override
    String getName();

    /**
     *
     * @return
     */
    boolean isComorbidityPresent();

    /**
     * @return the lowComorbidity
     */
    boolean isLowComorbidity();

    /**
     * @param description the description to set
     */
    @Override
    void setDescription(String description);

    /**
     * @param id the id to set
     */
    @Override
    void setId(int id);

    /**
     * @param lowComorbidity the lowComorbidity to set
     */
    void setLowComorbidity(boolean lowComorbidity);

    /**
     * @param name the name to set
     */
    @Override
    void setName(String name);
    
}
