/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.common.abstr.EditableIF;
import gov.cms.hh.common.abstr.ValidatableIF;
import gov.cms.hh.common.abstr.VerifiableIF;

/**
 *
 * @author CMS
 */
public interface DiagnosisIF extends EditableIF, VerifiableIF, ValidatableIF {

    /**
     * @return the clinicalGroup
     */
    ClinicalGroup getClinicalGroup();

    /**
     * @return the comorbidityGroup
     */
    ComorbidityGroup getComorbidityGroup();

    /**
     * @return the description
     */
    String getDescription();

    /**
     * @return the diagnosisSubchapter
     */
    DiagnosisSubchapter getDiagnosisSubchapter();

    /**
     * @return the id
     */
    int getId();

    /**
     * @return the value
     */
    String getValue();

    /**
     * @return the ECOI
     */
    boolean isECOI();

    /**
     * @return the manifestation
     */
    boolean isManifestation();

    /**
     * @return the primaryAwarding
     */
    boolean isPrimaryAwarding();

    /**
     * @return the codeFirst
     */
    boolean isCodeFirst();

    /**
     * @return the unacceptablePdx
     */
    boolean isUnacceptablePdx();

    /**
     * @param clinicalGroup the clinicalGroup to set
     */
    void setClinicalGroup(ClinicalGroup clinicalGroup);

    /**
     * @param comorbidityGroup the comorbidityGroup to set
     */
    void setComorbidityGroup(ComorbidityGroup comorbidityGroup);

    /**
     * @param description the description to set
     */
    void setDescription(String description);

    /**
     * @param diagnosisSubchapter the diagnosisSubchapter to set
     */
    void setDiagnosisSubchapter(DiagnosisSubchapter diagnosisSubchapter);

    /**
     * @param ECOI the ECOI to set
     */
    void setECOI(boolean ECOI);

    /**
     * @param codeFirst
     */
    void setCodeFirst(boolean codeFirst);

    /**
     * @param unacceptablePdx
     */
    void setUnacceptablePdx(boolean unacceptablePdx);
    
    /**
     * @param id the id to set
     */
    void setId(int id);

    /**
     * @param manifestation the manifestation to set
     */
    void setManifestation(boolean manifestation);

    /**
     * @param primaryAwarding the primaryAwarding to set
     */
    void setPrimaryAwarding(boolean primaryAwarding);

    /**
     * @param value the value to set
     */
    void setValue(String value);
    
}
