/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.processor;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.data.meta.enumer.EditType_EN;
import gov.cms.hh.data.meta.enumer.PeriodTiming_EN;
import gov.cms.hh.data.meta.enumer.ReferralSource_EN;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsPositionAbstract;
import gov.cms.hh.logic.processor.HippsPositionIF;
import gov.cms.hh.logic.specification.IsValidPeriodTiming;
import gov.cms.hh.logic.specification.IsValidReferralSource;
import gov.cms.hh.logic.validation.Edit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HippsPosition1
extends HippsPositionAbstract
implements HippsPositionIF {
    private static final Logger LOG = Logger.getLogger(HippsPosition1.class.getName());

    public HippsPosition1(ClaimIF claim, DataManagerIF dataManager) {
        super(claim, dataManager);
        this.setOrder(1);
    }

    @Override
    public boolean validate() {
        IsValidReferralSource referralSourceSpecs;
        int GRC_INVALID_PERIOD_TIMING = 2;
        boolean retFlag = true;
        IsValidPeriodTiming periodTimingSpecs = new IsValidPeriodTiming(this.getClaim().getPeriodTiming().getValue());
        if (!periodTimingSpecs.isSatisfiedBy(PeriodTiming_EN.values())) {
            this.getClaim().getPeriodTiming().setValid(false);
            this.getClaim().getPeriodTiming().addEdit(new Edit(EditId_EN.VALUE_INVALID, this.getClaim().getPeriodTiming().toString() + EditId_EN.VALUE_INVALID.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
            this.getClaim().getPeriodTiming().addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, this.getClaim().getPeriodTiming().toString() + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
            this.addReturnCode(2);
            retFlag = false;
        }
        if (!(referralSourceSpecs = new IsValidReferralSource(this.getClaim().getReferralSource().getValue())).isSatisfiedBy(ReferralSource_EN.values())) {
            this.getClaim().getReferralSource().setValid(false);
            Edit edit = new Edit(EditId_EN.VALUE_OUT_OF_RANGE, this.getClaim().getReferralSource().toString() + " is not in range", EditType_EN.INFO, Level.WARNING);
            this.getClaim().getReferralSource().addEdit(edit);
        }
        return retFlag;
    }

    @Override
    public boolean calculate() {
        boolean HIPPS_POSITION = true;
        boolean HIPPS_VALUE_1 = true;
        int HIPPS_VALUE_2 = 2;
        int HIPPS_VALUE_3 = 3;
        int HIPPS_VALUE_4 = 4;
        boolean retFlag = true;
        String text = null;
        String periodTiming = this.getClaim().getPeriodTiming().getValue();
        String ptDesc = (this.getClaim().getPeriodTiming().getDescription() == null ? "(no description)" : "(" + this.getClaim().getPeriodTiming().getDescription()) + ")";
        String referralSource = this.getClaim().getReferralSource().getValue();
        String rsDesc = (this.getClaim().getReferralSource().getDescription() == null ? "(no description)" : "(" + this.getClaim().getReferralSource().getDescription()) + ")";
        boolean isOutOfRange = !this.getClaim().getReferralSource().isValid();
        int hippsValue = 0;
        if (this.getClaim().getPeriodTiming().isValid()) {
            if (periodTiming.equals("" + PeriodTiming_EN.PERIOD_TIMING_EARLY.getId())) {
                hippsValue = isOutOfRange ? 1 : 2;
            }
            if (periodTiming.equals("" + PeriodTiming_EN.PERIOD_TIMING_LATE.getId())) {
                hippsValue = isOutOfRange ? 3 : 4;
            }
            text = "Period Timing = " + periodTiming + " " + ptDesc;
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS1, text);
            text = "Referral Source = " + (referralSource == null ? "(empty)" : referralSource + " " + rsDesc) + (isOutOfRange ? " (Out of range)" : "");
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS1, text);
            text = "HIPPS Position 1 = " + hippsValue;
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS1, text);
            return this.setHippsCode(1, "" + hippsValue);
        }
        text = "Period Timing = " + (periodTiming == null ? "(empty)" : periodTiming + " " + ptDesc) + " (Incorrect, SEVERE)";
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS1, text);
        text = "HIPPS Position 1 = " + hippsValue + " (Not calculated)";
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS1, text);
        retFlag = false;
        return retFlag;
    }
}

