/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.reference.objects;

import gov.cms.hh.data.exchange.ClaimContainerIF;
import gov.cms.hh.data.exchange.DxContainer;
import gov.cms.hh.data.exchange.DxContainerIF;
import gov.cms.hh.data.exchange.HippsContainerIF;
import gov.cms.hh.data.exchange.ReturnCodeContainerIF;
import gov.cms.hh.data.exchange.ValidityFlagContainerIF;
import gov.cms.hh.data.loader.PositionAccessorIF;
import gov.cms.hh.data.meta.enumer.Claim_EN;
import gov.cms.hh.data.meta.enumer.Oasis_EN;
import gov.cms.hh.logic.validation.EditCollectionIF;
import gov.cms.hh.xml.data.claim.Claim;
import gov.cms.hh.xml.data.claim.ClinicalFields;
import gov.cms.hh.xml.data.claim.Diagnoses;
import gov.cms.hh.xml.data.claim.Dx;
import gov.cms.hh.xml.data.claim.FunctionalField;
import gov.cms.hh.xml.data.claim.FunctionalFields;
import gov.cms.hh.xml.data.claim.GrouperReturnCode;
import gov.cms.hh.xml.data.claim.HippsCode;
import gov.cms.hh.xml.data.claim.Input;
import gov.cms.hh.xml.data.claim.Options;
import gov.cms.hh.xml.data.claim.Output;
import gov.cms.hh.xml.data.claim.Principal;
import gov.cms.hh.xml.data.claim.Secondary;
import gov.cms.hh.xml.data.claim.Subfield;
import gov.cms.hh.xml.data.claim.ValidityFlag;
import gov.cms.hh.xml.data.claim.VersionUsed;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ClaimObject
extends Claim
implements PositionAccessorIF,
ClaimContainerIF {
    private boolean loadDescription;

    public ClaimObject() {
        this.init();
    }

    private void init() {
        this.setOptions(new Options());
        this.setInput(new Input());
        this.getInput().setClinicalFields(new ClinicalFields());
        this.getInput().getClinicalFields().setDiagnoses(new Diagnoses());
        this.getInput().getClinicalFields().getDiagnoses().setPrincipal(new Principal());
        this.getInput().getClinicalFields().getDiagnoses().setSecondary(new Secondary());
        this.getInput().setFunctionalFields(new FunctionalFields());
        this.setOutput(new Output());
        this.getOutput().setVersionUsed(new VersionUsed());
        this.getOutput().setHippsCode(new HippsCode());
        this.getOutput().setValidityFlag(new ValidityFlag());
        this.getOutput().setGrouperReturnCode(new GrouperReturnCode());
    }

    public String toString() {
        String nl = "\n";
        return "ClaimObject{" + nl + "ID='" + this.getId() + "'" + nl + "Description='" + (this.getDescription() == null ? "" : this.getDescription()) + "'" + nl + "From Date='" + this.getInput().getClinicalFields().getFromDate() + "'" + nl + "Through Date='" + this.getInput().getClinicalFields().getThroughDate() + "'" + nl + "Period Timing='" + this.getInput().getClinicalFields().getPeriodTiming() + "'" + nl + "Referral Source='" + this.getInput().getClinicalFields().getReferralSource() + "'" + nl + this.formatDx(this.getInput().getClinicalFields().getDiagnoses().getPrincipal().getDx(), "P", nl) + this.formatDx(this.getInput().getClinicalFields().getDiagnoses().getSecondary().getDx(), "S", nl) + this.formatOasis(this.getInput().getFunctionalFields().getFunctionalField(), nl) + "Version Used='" + this.formatVersion(this.getOutput().getVersionUsed()) + "'" + nl + "HIPPS Code='" + this.formatHippsCode(this.getOutput().getHippsCode()) + "'" + nl + "Validity Flag='" + this.getOutput().getValidityFlag().getValue() + "'" + nl + "Grouper Return Code='" + this.getOutput().getGrouperReturnCode().getValue() + "'" + nl + "ActionFlag='" + this.getOptions().getActionFlag() + "'" + nl + "}";
    }

    @Override
    public String getByPosition(int position) {
        if (position == Claim_EN.ID.getItemNumberStart()) {
            return this.getId();
        }
        if (position == Claim_EN.FROM_DATE.getItemNumberStart()) {
            return this.getInput().getClinicalFields().getFromDate();
        }
        if (position == Claim_EN.PERIOD_TIMING.getItemNumberStart()) {
            return this.getInput().getClinicalFields().getPeriodTiming();
        }
        if (position == Claim_EN.REFERRAL_SOURCE.getItemNumberStart()) {
            return this.getInput().getClinicalFields().getReferralSource();
        }
        if (position == Claim_EN.PDX.getItemNumberStart()) {
            Dx dx = this.getInput().getClinicalFields().getDiagnoses().getPrincipal().getDx();
            String retDx = dx.getCode() + dx.getPoa();
            return retDx;
        }
        if (position >= Claim_EN.SDX.getItemNumberStart() && position <= Claim_EN.SDX.getItemNumberEnd()) {
            return this.getInput().getClinicalFields().getDiagnoses().getSecondary().getDx().get(position - 5).getCode();
        }
        if (position >= Claim_EN.M1033.getItemNumberStart() && position <= Claim_EN.M1033.getItemNumberEnd()) {
            this.getInput().getFunctionalFields().getFunctionalField().get(0).getSubfield().get(position - 34).getValue();
        }
        if (position >= Claim_EN.M18XX.getItemNumberStart() && position <= Claim_EN.M18XX.getItemNumberEnd()) {
            this.getInput().getFunctionalFields().getFunctionalField().get(position - 44).getSubfield().get(0).getValue();
        }
        if (position == Claim_EN.THROUGH_DATE.getItemNumberStart()) {
            return this.getInput().getClinicalFields().getThroughDate();
        }
        return null;
    }

    @Override
    public boolean setByPosition(int position, String value) {
        Subfield sf;
        FunctionalField ff;
        if (position == Claim_EN.ID.getItemNumberStart()) {
            this.setId(value);
        }
        if (position == Claim_EN.FROM_DATE.getItemNumberStart()) {
            this.getInput().getClinicalFields().setFromDate(value);
        }
        if (position == Claim_EN.PERIOD_TIMING.getItemNumberStart()) {
            this.getInput().getClinicalFields().setPeriodTiming(value);
        }
        if (position == Claim_EN.REFERRAL_SOURCE.getItemNumberStart()) {
            this.getInput().getClinicalFields().setReferralSource(value);
        }
        if (position == Claim_EN.PDX.getItemNumberStart()) {
            Dx dx = new Dx();
            dx.setCode(value.substring(0, value.length() - 1));
            dx.setPoa(value.substring(value.length() - 1));
            dx.setOccurrence("0");
            this.getInput().getClinicalFields().getDiagnoses().getPrincipal().setDx(dx);
        }
        if (position >= Claim_EN.SDX.getItemNumberStart() && position <= Claim_EN.SDX.getItemNumberEnd()) {
            List<Dx> dxList = this.getInput().getClinicalFields().getDiagnoses().getSecondary().getDx();
            Dx dx = new Dx();
            dx.setCode(value.substring(0, value.length() - 1));
            dx.setPoa(value.substring(value.length() - 1));
            dx.setOccurrence("" + (dxList.size() + 1));
            dxList.add(dx);
        }
        if (position >= Claim_EN.M1033.getItemNumberStart() && position <= Claim_EN.M1033.getItemNumberEnd()) {
            ff = null;
            if (position == Claim_EN.M1033.getItemNumberStart()) {
                ff = new FunctionalField();
                String name = Oasis_EN.values()[0].name().substring(0, 5);
                ff.setFieldName(name);
                this.getInput().getFunctionalFields().getFunctionalField().add(ff);
            } else {
                ff = this.getInput().getFunctionalFields().getFunctionalField().get(0);
            }
            sf = new Subfield();
            sf.setName(Oasis_EN.values()[position - Claim_EN.M1033.getItemNumberStart()].name());
            sf.setValue(value);
            ff.getSubfield().add(sf);
        }
        if (position >= Claim_EN.M18XX.getItemNumberStart() && position <= Claim_EN.M18XX.getItemNumberEnd()) {
            ff = new FunctionalField();
            sf = new Subfield();
            String name = Oasis_EN.values()[position - (Claim_EN.M18XX.getItemNumberStart() - 10)].name();
            ff.setFieldName(name.substring(0, 5));
            sf.setName(name);
            sf.setValue(value);
            ff.getSubfield().add(sf);
            this.getInput().getFunctionalFields().getFunctionalField().add(ff);
        }
        if (position == Claim_EN.THROUGH_DATE.getItemNumberStart()) {
            this.getInput().getClinicalFields().setThroughDate(value);
        }
        if (position == Claim_EN.ACTION_FLAG.getItemNumberStart()) {
            this.getOptions().setActionFlag(value);
        }
        if (position == Claim_EN.VERSION.getItemNumberStart()) {
            VersionUsed vu = this.getOutput().getVersionUsed();
            if (value.contains(".")) {
                vu.setVersion(value.substring(0, 2));
                vu.setRelease(value.substring(3, 4));
                vu.setYear(value.substring(5));
            } else {
                vu.setVersion(value);
                vu.setRelease("");
                vu.setYear("");
            }
        }
        if (position == Claim_EN.HIPPS.getItemNumberStart()) {
            HippsCode hc = this.getOutput().getHippsCode();
            hc.setEpisodeTiming(value.substring(0, 1));
            hc.setClinicalGroup(value.substring(1, 2));
            hc.setFunctionalLevel(value.substring(2, 3));
            hc.setComorbidityPresent(value.substring(3, 4));
            hc.setFiller(value.substring(4, 5));
        }
        if (position == Claim_EN.VALIDITY_FLAG.getItemNumberStart()) {
            ValidityFlag vf = this.getOutput().getValidityFlag();
            vf.setValue(value);
        }
        if (position == Claim_EN.RETURN_CODE.getItemNumberStart()) {
            GrouperReturnCode grc = this.getOutput().getGrouperReturnCode();
            grc.setValue(value);
        }
        return false;
    }

    private String formatDx(Dx dx, String pref, String del) {
        if (dx.getCode().trim().isEmpty()) {
            return null;
        }
        return pref + "DX='{'" + dx.getCode() + "','" + dx.getPoa() + "','" + dx.getOccurrence() + "'}" + del;
    }

    private String formatDx(List<Dx> dxList, String pref, String del) {
        StringBuilder ret = new StringBuilder();
        dxList.stream().map(dx -> this.formatDx((Dx)dx, pref, del)).filter(retStr -> retStr != null).forEachOrdered(retStr -> ret.append((String)retStr));
        return ret.toString();
    }

    private String formatOasis(List<FunctionalField> ffList, String del) {
        String ret = "";
        for (FunctionalField ff : ffList) {
            List<Subfield> sfList = ff.getSubfield();
            ret = sfList.stream().map(sf -> "OASIS Field={" + sf.getName() + "='" + sf.getValue() + "'}" + del).reduce(ret, String::concat);
        }
        return ret;
    }

    private String formatVersion(VersionUsed vu) {
        String ret = "";
        ret = vu.getVersion() + "." + vu.getRelease() + "." + vu.getYear();
        return ret;
    }

    private String formatHippsCode(HippsCode hc) {
        String ret = "";
        ret = hc.getEpisodeTiming() + hc.getClinicalGroup() + hc.getFunctionalLevel() + hc.getComorbidityPresent() + hc.getFiller();
        return ret;
    }

    public String tempGetOutput() {
        return this.formatVersion(this.getOutput().getVersionUsed()) + this.formatHippsCode(this.getOutput().getHippsCode()) + this.getOutput().getValidityFlag().getValue() + this.getOutput().getGrouperReturnCode().getValue();
    }

    @Override
    public int getNumberOfFields() {
        return 57;
    }

    @Override
    public boolean isLoadDescription() {
        return this.loadDescription;
    }

    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }

    @Override
    public String getHippsCode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getReturnCodeValue() {
        return this.getOutput().getGrouperReturnCode().getValue();
    }

    @Override
    public String getReturnCodeDescription() {
        return this.getOutput().getGrouperReturnCode().getDescription();
    }

    @Override
    public String getValidityFlagValue() {
        return this.getOutput().getValidityFlag().getValue();
    }

    @Override
    public String getValidityFlagDescription() {
        return this.getOutput().getValidityFlag().getDescription();
    }

    @Override
    public String getVersionUsed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAmbulation(String ambulation) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBathing(String bathing) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClaimId() {
        return this.getId();
    }

    @Override
    public void setClaimId(String claimId) {
        this.setId(claimId);
    }

    @Override
    public void setDressLower(String dressLower) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDressUpper(String dressUpper) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setFromDate(String fromDate) {
        this.getInput().getClinicalFields().setFromDate(fromDate);
    }

    @Override
    public void setThroughDate(String throughDate) {
        this.getInput().getClinicalFields().setThroughDate(throughDate);
    }

    @Override
    public void setGrooming(String grooming) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskCompliance(String hospRiskCompliance) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskFiveMoreMeds(String hospRiskFiveMoreMeds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskHistoryFalls(String hospRiskHistoryFalls) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskMentalBehavDecl(String hospRiskMentalBehavDecl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskMultiEdVisit(String hospRiskMultiEdVisit) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskMultiHospital(String hospRiskMultiHospital) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskNoneAbove(String hospRiskNoneAbove) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskOtherRisk(String hospRiskOtherRisk) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskExhaustion(String hospRiskExhaustion) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskWeightLoss(String hospRiskWeightLoss) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPdx(String pdx, String poa) {
        Dx dx = new Dx();
        dx.setCode(pdx);
        dx.setPoa(poa);
        dx.setOccurrence("0");
        this.getInput().getClinicalFields().getDiagnoses().getPrincipal().setDx(dx);
    }

    @Override
    public void addSdx(String sdx, String poa) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPeriodTiming(String periodTiming) {
        this.getInput().getClinicalFields().setPeriodTiming(periodTiming);
    }

    @Override
    public void setReferralSource(String referralSource) {
        this.getInput().getClinicalFields().setReferralSource(referralSource);
    }

    @Override
    public void setToileting(String toileting) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTransferring(String transferring) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getAmbulation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getBathing() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDressLower() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDressUpper() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getFromDate() {
        return this.getInput().getClinicalFields().getFromDate();
    }

    @Override
    public String getThroughDate() {
        return this.getInput().getClinicalFields().getThroughDate();
    }

    @Override
    public String getGrooming() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskCompliance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskFiveMoreMeds() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskHistoryFalls() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskMentalBehavDecl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskMultiEdVisit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskMultiHospital() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskNoneAbove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskOtherRisk() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskExhaustion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskWeightLoss() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DxContainerIF getPdx() {
        Dx dx = this.getInput().getClinicalFields().getDiagnoses().getPrincipal().getDx();
        DxContainer pdx = new DxContainer(dx.getCode(), dx.getPoa());
        return pdx;
    }

    @Override
    public String getPeriodTiming() {
        return this.getInput().getClinicalFields().getPeriodTiming();
    }

    @Override
    public String getReferralSource() {
        return this.getInput().getClinicalFields().getReferralSource();
    }

    @Override
    public ReturnCodeContainerIF getReturnCode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<DxContainerIF> getSdxList() {
        ArrayList<DxContainer> retList = null;
        List<Dx> dxList = this.getInput().getClinicalFields().getDiagnoses().getSecondary().getDx();
        for (Dx dx : dxList) {
            DxContainer diag = new DxContainer(dx.getCode(), dx.getPoa());
            if (retList == null) {
                retList = new ArrayList<DxContainer>();
            }
            retList.add(diag);
        }
        return retList;
    }

    @Override
    public String getToileting() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getTransferring() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ValidityFlagContainerIF getValidityFlag() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHippsCode(String HippsCode2) {
        this.setByPosition(Claim_EN.HIPPS.getItemNumberStart(), HippsCode2);
    }

    @Override
    public void setPdx(DxContainerIF pdx) {
        Dx dx = new Dx();
        dx.setCode(pdx.getDx());
        dx.setPoa(pdx.getPoa());
        dx.setOccurrence("0");
        this.getInput().getClinicalFields().getDiagnoses().getPrincipal().setDx(dx);
    }

    @Override
    public void setReturnCode(ReturnCodeContainerIF returnCode) {
        this.getOutput().getGrouperReturnCode().setValue(returnCode.getValue());
        this.getOutput().getGrouperReturnCode().setDescription(returnCode.getDescription());
    }

    @Override
    public void setSdxList(List<DxContainerIF> sdxList) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setValidityFlag(ValidityFlagContainerIF validityFlag) {
        this.getOutput().getValidityFlag().setValue(validityFlag.getValue());
        this.getOutput().getValidityFlag().setDescription(validityFlag.getDescription());
    }

    @Override
    public void setVersionUsed(String versionUsed) {
        this.setByPosition(Claim_EN.VERSION.getItemNumberStart(), versionUsed);
    }

    @Override
    public Map<String, String> getFunctionalFields() {
        TreeMap<String, String> retMap = new TreeMap<String, String>();
        List<FunctionalField> ffList = this.getInput().getFunctionalFields().getFunctionalField();
        for (FunctionalField ff : ffList) {
            List<Subfield> sfList = ff.getSubfield();
            for (Subfield sf : sfList) {
                retMap.put(sf.getName(), sf.getValue());
            }
        }
        return retMap;
    }

    @Override
    public EditCollectionIF getEdits() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEdits(EditCollectionIF edits) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HippsContainerIF getHippsContainer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHippsContainer(HippsContainerIF hippsContainerIF) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

