/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.processor;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsPosition1;
import gov.cms.hh.logic.processor.HippsPosition2;
import gov.cms.hh.logic.processor.HippsPosition3;
import gov.cms.hh.logic.processor.HippsPosition4;
import gov.cms.hh.logic.processor.HippsPosition5;
import gov.cms.hh.logic.processor.HippsPositionIF;
import gov.cms.hh.logic.processor.HippsProcessorIF;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HippsProcessor
implements HippsProcessorIF {
    @Override
    public void process(ClaimIF claim, DataManagerIF dataManager) {
        this.executeLogic(this.buildLogic(claim, dataManager));
    }

    protected Map<Integer, HippsPositionIF> buildLogic(ClaimIF claim, DataManagerIF dataManager) {
        TreeMap<Integer, HippsPositionIF> retSteps = new TreeMap<Integer, HippsPositionIF>();
        List<HippsPositionIF> steps = Arrays.asList(new HippsPosition1(claim, dataManager), new HippsPosition2(claim, dataManager), new HippsPosition3(claim, dataManager), new HippsPosition4(claim, dataManager), new HippsPosition5(claim, dataManager));
        for (HippsPositionIF step : steps) {
            retSteps.put(step.getOrder(), step);
        }
        return retSteps;
    }

    protected void executeLogic(Map<Integer, HippsPositionIF> steps) {
        for (Integer position : steps.keySet()) {
            HippsPositionIF step = steps.get(position);
            step.validate();
            step.calculate();
        }
    }
}

