/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.v04123;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.data.meta.enumer.EditType_EN;
import gov.cms.hh.diagnosis.ClinicalGroupIF;
import gov.cms.hh.diagnosis.CodeFirstCondition;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.specification.condition.ConditionChecker;
import gov.cms.hh.logic.validation.Edit;
import gov.cms.hh.reference.objects.CodeFirstConditionObject;
import gov.cms.hh.v04023.HippsPosition2_v04023;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;

public class HippsPosition2_v04123
extends HippsPosition2_v04023 {
    public HippsPosition2_v04123(ClaimIF claim, DataManagerIF dataManager) {
        super(claim, dataManager);
    }

    @Override
    protected boolean checkAsPdx(String label, DiagnosisIF pdx) {
        int GRC_INVALID_PDX = 3;
        int GRC_UNGROUPABLE_PDX = 5;
        boolean GVF_UNACCEPTABLE_PDX = true;
        int GVF_MANIFESTATION_PDX = 2;
        int GVF_UNSPECIFIED_PDX = 3;
        int GVF_ECOI_PDX = 4;
        int GVF_CODE_FIRST_PDX = 5;
        int GVF_INVALID_PDX = 6;
        int GVF_BLANK_PDX = 7;
        boolean retFlag = true;
        if (!pdx.getEditCollection().hasEditId(EditId_EN.VALUE_INVALID)) {
            ClinicalGroupIF cg = pdx.getClinicalGroup();
            if (cg == null || cg.getValue().isEmpty() || cg.getValue().equalsIgnoreCase("na")) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " has no Clinical Group assigned, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(5);
                retFlag = false;
            }
            if (pdx.isManifestation()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " is manifestation DX, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(3);
                this.addValidityFlag(2);
                retFlag = false;
            }
            if (pdx.isECOI()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " is ECOI DX, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(3);
                this.addValidityFlag(4);
                retFlag = false;
            }
            if (pdx.isUnacceptablePdx()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " is unacceptable as PDX DX, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(3);
                this.addValidityFlag(1);
                retFlag = false;
            }
            if (pdx.isUnspecifiedPdx()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " is unspecified as PDX DX, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(3);
                this.addValidityFlag(3);
                retFlag = false;
            }
            if (pdx.isCodeFirst()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_CODE_FIRST, label + " " + pdx + " has Code First Condition, " + EditId_EN.VALUE_CODE_FIRST.getDescription(), EditType_EN.CONSISTENCY, Level.INFO));
                if (this.checkCodeFirstCondition(pdx)) {
                    this.addValidityFlag(5);
                }
            }
        } else {
            this.addReturnCode(3);
            if (pdx.getValue().trim().isEmpty()) {
                this.addValidityFlag(7);
            } else {
                this.addValidityFlag(6);
            }
            retFlag = false;
        }
        return retFlag;
    }

    private boolean checkCodeFirstCondition(DiagnosisIF pdx) {
        String range = pdx.getCodeFirstCondition().getValue();
        ConditionChecker cfc = new ConditionChecker(range);
        List<DiagnosisIF> sdxList = this.getClaim().getSecondaryDiagnoses().getCollection();
        for (DiagnosisIF dx : sdxList) {
            if (!dx.isValid() || !cfc.isCodeFirstConditionSatisfied(dx.getValue())) continue;
            String edit = "SDX = %s, " + EditId_EN.VALUE_CODE_FIRST.getDescription();
            dx.addEdit(new Edit(EditId_EN.VALUE_CODE_FIRST, String.format(edit, dx), EditType_EN.SPECIFICATION, Level.INFO));
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, String.format(edit, dx.getValue() + " (" + dx.getDescription() + ")"));
            return true;
        }
        return false;
    }

    private CodeFirstConditionObject getCodeFirstConditionReference(int id) {
        for (Object obj : this.getDataManager().getDataMap().get(TableNames_EN.CodeFirst_Conditions).getData()) {
            if (Integer.parseInt(((CodeFirstConditionObject)obj).getId()) != id) continue;
            return (CodeFirstConditionObject)obj;
        }
        return null;
    }

    @Override
    protected DiagnosisIF getDiagnosisReference(String value) throws ParseException {
        DiagnosisIF dx = super.getDiagnosisReference(value);
        if (dx != null && dx.isCodeFirst()) {
            CodeFirstCondition cfc = new CodeFirstCondition(this.getCodeFirstConditionReference(dx.getCodeFistConditionId()));
            dx.setCodeFirstCondition(cfc);
        }
        return dx;
    }
}

