/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.data.meta.enumer.EditType_EN;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.logic.validation.Edit;
import gov.cms.hh.logic.validation.EditCollection;
import gov.cms.hh.logic.validation.EditCollectionIF;
import java.util.Comparator;
import java.util.Optional;
import java.util.logging.Level;

/**
 *
 * @author CMS
 */
public class Claim extends ClaimElementBase implements ClaimIF {

    private static final long serialVersionUID = 1L;
    
    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "Claim{" + "validityFlags=" + validityFlags + ", returnCodes=" + returnCodes + ", oasisFields=" + oasisFields + ", hippsCode=" + hippsCode + ", secondaryDiagnoses=" + secondaryDiagnoses + ", primaryDiagnosis=" + primaryDiagnosis + ", referralSource=" + referralSource + ", dateFrom=" + dateFrom + ", periodTiming=" + periodTiming + ", ClaimId=" + claimId + '}';
    }

    /**
     * Constructor
     */
    public Claim() {
        hippsCode = new HippsCode();
        secondaryDiagnoses = new ClaimElementCollection<>();
        oasisFields = new ClaimElementCollection<>();
        returnCodes = new ClaimElementCollection<>();
        validityFlags = new ClaimElementCollection<>();
    }

    /**
     * @return the validityFlags
     */
    @Override
    public ClaimElementCollectionIF<ValidityFlag> getValidityFlags() {
        return validityFlags;
    }

    /**
     * @param validityFlags the validityFlags to set
     */
    @Override
    public void setValidityFlags(ClaimElementCollectionIF<ValidityFlag> validityFlags) {
        this.validityFlags = validityFlags;
    }

    /**
     * @return the returnCodes
     */
    @Override
    public ClaimElementCollectionIF<ReturnCode> getReturnCodes() {
        return returnCodes;
    }

    /**
     * @param returnCodes the returnCodes to set
     */
    @Override
    public void setReturnCodes(ClaimElementCollectionIF<ReturnCode> returnCodes) {
        this.returnCodes = returnCodes;
    }

    /**
     * @return the oasisFields
     */
    @Override
    public ClaimElementCollectionIF<OasisResponseIF> getOasisFields() {
        return oasisFields;
    }

    /**
     * @param oasisFields the oasisFields to set
     */
    @Override
    public void setOasisFields(ClaimElementCollectionIF<OasisResponseIF> oasisFields) {
        this.oasisFields = oasisFields;
    }

    /**
     * @return the hippsCode
     */
    @Override
    public HippsCodeIF getHippsCode() {
        return hippsCode;
    }

    /**
     * @param hippsCode the hippsCode to set
     */
    @Override
    public void setHippsCode(HippsCodeIF hippsCode) {
        this.hippsCode = hippsCode;
    }

    /**
     * @return the secondaryDiagnoses
     */
    @Override
    public ClaimElementCollectionIF<DiagnosisIF> getSecondaryDiagnoses() {
        return secondaryDiagnoses;
    }

    /**
     * @param secondaryDiagnoses the secondaryDiagnoses to set
     */
    @Override
    public void setSecondaryDiagnoses(ClaimElementCollectionIF<DiagnosisIF> secondaryDiagnoses) {
        this.secondaryDiagnoses = secondaryDiagnoses;
    }

    /**
     * @return the primaryDiagnosis
     */
    @Override
    public DiagnosisIF getPrimaryDiagnosis() {
        return primaryDiagnosis;
    }

    /**
     * @param primaryDiagnosis the primaryDiagnosis to set
     */
    @Override
    public void setPrimaryDiagnosis(DiagnosisIF primaryDiagnosis) {
        this.primaryDiagnosis = primaryDiagnosis;
    }

    /**
     * @return the referralSource
     */
    @Override
    public ReferralSourceIF getReferralSource() {
        return referralSource;
    }

    /**
     * @param referralSource the referralSource to set
     */
    @Override
    public void setReferralSource(ReferralSourceIF referralSource) {
        this.referralSource = referralSource;
    }

    /**
     * @return the dateFrom
     */
    @Override
    public ClaimDateIF getDateFrom() {
        return dateFrom;
    }

    /**
     * @param dateFrom the dateFrom to set
     */
    @Override
    public void setDateFrom(ClaimDateIF dateFrom) {
        this.dateFrom = dateFrom;
    }

    private ClaimElementCollectionIF<ValidityFlag> validityFlags;
    private ClaimElementCollectionIF<ReturnCode> returnCodes;
    private ClaimElementCollectionIF<OasisResponseIF> oasisFields;
    private HippsCodeIF hippsCode;
    private ClaimElementCollectionIF<DiagnosisIF> secondaryDiagnoses;
    private DiagnosisIF primaryDiagnosis;
    private ReferralSourceIF referralSource;
    private ClaimDateIF dateFrom;
    private ClaimDateIF dateThrough;
    private PeriodTimingIF periodTiming;
    private String claimId;
    private String grouperVersion;

    /**
     * @return the periodTiming
     */
    @Override
    public PeriodTimingIF getPeriodTiming() {
        return periodTiming;
    }

    /**
     * @param periodTiming the periodTiming to set
     */
    @Override
    public void setPeriodTiming(PeriodTimingIF periodTiming) {
        this.periodTiming = periodTiming;
    }

    /**
     * @return the claimId
     */
    @Override
    public String getClaimId() {
        return claimId;
    }

    /**
     * @param ClaimId the claimId to set
     */
    @Override
    public void setClaimId(String ClaimId) {
        this.claimId = ClaimId;
    }

    /**
     *
     * @return
     */
    @Override
    public ReturnCode getSingleReturnCode() {
        if (!returnCodes.getCollection().isEmpty()) {
            Optional<ReturnCode> retGrc = returnCodes.getCollection()
                    .stream()
                    .min(Comparator.comparing(ReturnCode::getId));
            if (retGrc.isPresent()) {
                return retGrc.get();
            }
        }
        return new ReturnCode(50, "Fatal error - Component corrupted or not set up");
    }

    /**
     *
     * @return
     */
    @Override
    public ValidityFlag getSingleValidityFlag() {
        if (!validityFlags.getCollection().isEmpty()) {
            Optional<ValidityFlag> retVal = validityFlags.getCollection()
                    .stream()
                    .min(Comparator.comparing(ValidityFlag::getId));
            if (retVal.isPresent()) {
                return retVal.get();
            }
        }
        return new ValidityFlag(0, "Validity Flag not set");
    }

    /**
     * @return the grouperVersion
     */
    @Override
    public String getGrouperVersion() {
        return grouperVersion;
    }

    /**
     * @param grouperVersion the grouperVersion to set
     */
    @Override
    public void setGrouperVersion(String grouperVersion) {
        this.grouperVersion = grouperVersion;
    }

    /**
     *
     * @return
     */
    @Override
    public EditCollectionIF getClaimEdits() {

        // This is temp report (prototype)
        EditCollectionIF retEdColl = new EditCollection();
        // All claim edits
        retEdColl.addEdits(this.getEditCollection().getEdits());
        // Date From
        if (dateFrom != null) {
            retEdColl.addEdits(dateFrom.getEditCollection().getEdits());
        }
        // Period Timing
        if (periodTiming != null) {
            retEdColl.addEdits(periodTiming.getEditCollection().getEdits());
        }
        // Referral Source
        if (referralSource != null) {
            retEdColl.addEdits(referralSource.getEditCollection().getEdits());
        }
        // Primary Diagnosis
        if (primaryDiagnosis != null) {
            retEdColl.addEdits(primaryDiagnosis.getEditCollection().getEdits());
        }
        // SDX container
        retEdColl.addEdits(secondaryDiagnoses.getEditCollection().getEdits());
        // individual SDXs
        secondaryDiagnoses.getCollection().forEach((sdx) -> {
            retEdColl.addEdits(sdx.getEditCollection().getEdits());
        });
        // OASIS container
        retEdColl.addEdits(oasisFields.getEditCollection().getEdits());
        // individual Oasis Fields
        oasisFields.getCollection().forEach((field) -> {
            retEdColl.addEdits(field.getEditCollection().getEdits());
        });
        // HIPPS code
        retEdColl.addEdits(hippsCode.getEditCollection().getEdits());
        // Additional Return Codes
        returnCodes.getCollection().forEach((returnCode) -> {
            retEdColl.addEdit(
                    new Edit(EditId_EN.VALUE_RETURN, returnCode.toString(), EditType_EN.INFO, Level.INFO)
            );
        });
        // Additional Validity Flags
        validityFlags.getCollection().forEach((validityFlag) -> {
            retEdColl.addEdit(
                    new Edit(EditId_EN.VALUE_RETURN, validityFlag.toString(), EditType_EN.INFO, Level.INFO)
            );
        });

        return retEdColl;
    }

    /**
     *
     * @param returnCode
     * @return
     */
    @Override
    public boolean hasReturnCode(int returnCode) {
        for (ReturnCode rc : returnCodes.getCollection()) {
            if(rc.getId() == returnCode) {
                return true;
            }
        }
        return false;
    }

    /**
     *
     * @param validityFlag
     * @return
     */
    @Override
    public boolean hasValidityFlag(int validityFlag) {
        for (ValidityFlag vf : validityFlags.getCollection()) {
            if(vf.getId() == validityFlag) {
                return true;
            }
        }
        return false;
    }

    /**
     * @return the dateThrough
     */
    @Override
    public ClaimDateIF getDateThrough() {
        return dateThrough;
    }

    /**
     * @param dateThrough the dateThrough to set
     */
    @Override
    public void setDateThrough(ClaimDateIF dateThrough) {
        this.dateThrough = dateThrough;
    }

}
