/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.common.abstr.EditableIF;
import gov.cms.hh.common.abstr.ValidatableIF;
import gov.cms.hh.common.abstr.VerifiableIF;
import gov.cms.hh.logic.validation.EditCollection;
import gov.cms.hh.logic.validation.EditCollectionIF;
import gov.cms.hh.logic.validation.EditIF;
import java.io.Serializable;
import java.util.List;

/**
 *
 * @author CMS
 */
public class ClaimElementBase implements EditableIF, VerifiableIF, ValidatableIF, Serializable{

    
    /**
     * ctor
     */

    public ClaimElementBase() {
        edits = new EditCollection();
        valid = true;
    }

    private static final long serialVersionUID = 1L;
    
    private final EditCollectionIF edits;
    private boolean verified;
    private boolean valid;
    
    /**
     * @return the edits
     */
    @Override
    public EditCollectionIF getEditCollection() {
        return edits;
    }

    /**
     * @param edits the edits to set
     */
//    public void setEdits(EditCollectionIF edits) {
//        this.edits = edits;
//    }

    /**
     *
     * @param edits
     */
    @Override
    public void addEdits(List<EditIF> edits) {
        this.edits.addEdits(edits);
    }

    /**
     *
     * @param edit
     */
    @Override
    public void addEdit(EditIF edit) {
        edits.addEdit(edit);
    }

    /**
     * @return the verified
     */
    @Override
    public boolean isVerified() {
        return verified;
    }

    /**
     * @param verified the verified to set
     */
    @Override
    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    /**
     * @return the valid
     */
    @Override
    public boolean isValid() {
        return valid;
    }

    /**
     * @param valid the valid to set
     */
    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

}
