/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.reference.objects.ValidityFlagObject;
import java.text.ParseException;

/**
 *
 * @author CMS
 */
public class ValidityFlag implements ValidityFlagIF {

    private static final long serialVersionUID = 1L;
    
    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "ValidityFlag{" + "id=" + id + ", description=" + description + '}';
    }

    /**
     * Constructor
     */
    public ValidityFlag() {
    }

    /**
     *
     * @param vfo
     * @throws ParseException
     */
    public ValidityFlag(ValidityFlagObject vfo) throws ParseException {
        this.id = Integer.parseInt(vfo.getFlag());
        this.description = vfo.getDescription();
    }
    
    /**
     *
     * @param id
     * @param description
     */
    public ValidityFlag(int id, String description) {
        this.id = id;
        this.description = description;
    }

    /**
     * @return the value
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id    */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    private int id;
    private String description;
    
}
