/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.data.meta.enumer;

import gov.cms.hh.common.abstr.DescribableIF;
import gov.cms.hh.common.abstr.IdentifiableIF;

/**
 *
 * @author CMS
 */
public enum PeriodTiming_EN implements DescribableIF, IdentifiableIF {

    // Claim Period Timing

    /**
     *
     */

    PERIOD_TIMING_EARLY(1,"Period Timing: Early"),

    /**
     *
     */
    PERIOD_TIMING_LATE(2,"Period Timing: Late")
    ;
    
    private String description;
    private int id;

    private PeriodTiming_EN(int id, String description) {
        this.id = id;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return description;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

}
