/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.abstr.AbstractClaimDateValidator;
import java.util.Date;

/**
 *
 * @author CMS
 */
public class IsValidFromDate extends AbstractClaimDateValidator {

    public IsValidFromDate(String date) {
        super(date);
    }

    /**
     *
     * @param gv
     * @return
     */
    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return isDateInBetweenIncludingEndPoints(gv.getStartDate(), gv.getEndDate());
    }

    private boolean isDateInBetweenIncludingEndPoints(final Date min, final Date max) {
        if (getDate() == null) {
            return false;
        }
        return !(getDate().before(min) || getDate().after(max));
    }

}
