/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.reference.objects;

import gov.cms.hh.data.loader.PositionAccessorIF;
import gov.cms.hh.xml.layout.rot.ClinicalGroup;

/**
 *
 * @author CMS
 */
public class ClinicalGroupObject extends ClinicalGroup implements PositionAccessorIF {

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "Clinical Group ID:'" + getId() +
                "', Clinical Group Name:'" + getName() +
                "', Clinical Group:'" + getDescription() +
                "', Low Points:'" + getLowPoints() +
                "', High Points:'" + getHighPoints() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getId();
            case 1:
                return getName();
            case 2:
                return getDescription();
            case 3:
                return getLowPoints();
            case 4:
                return getHighPoints();
            default:
                return null; // Exception???
        }
    }

    /**
     *
     * @param position
     * @param value
     * @return
     */
    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setId(value);
                return true;
            case 1:
                setName(value);
                return true;
            case 2:
                setDescription(value);
                return true;
            case 3:
                setLowPoints(value);
                return true;
            case 4:
                setHighPoints(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 5;
    }
    
    /**
     *
     * @param value
     */
    @Override
    public void setDescription(String value) {
        if (isLoadDescription()) {
            super.setDescription(value);
        }
    }

    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }
    
}
