package gov.cms.hh.v04023;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsPosition2;

/**
 *
 * @author CMS
 */
public class HippsPosition2_v04023 extends HippsPosition2 {

    /**
     *
     * @param claim
     * @param dataManager
     */
    public HippsPosition2_v04023(ClaimIF claim, DataManagerIF dataManager) {
        super(claim, dataManager);
    }

    /**
     *
     * @return
     */
    @Override
    public boolean calculate() {
        boolean ret_flag = super.calculate();
        DiagnosisIF pdx = getClaim().getPrimaryDiagnosis();
        // Add message for detail report if PDX gets substituted
        if (pdx.getEditCollection().hasEditId(EditId_EN.VALUE_SUBSTITUTED_FOR_SPAN)) {
            addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, EditId_EN.DATE_SPAN.getDescription());
            String text = "PDX = " + pdx.getValue() + " (" + pdx.getDescription() + "), "
                    + EditId_EN.VALUE_SUBSTITUTED_FOR_SPAN.getDescription();
            addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
        }
        return ret_flag;
    }

}
