
package gov.cms.hh.v04223;

import gov.cms.hh.v04123.*;
import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsPositionIF;
import java.util.Map;

/**
 *
 * @author CMS
 */
public class HippsProcessor_v04223 extends HippsProcessor_v04123 {
    @Override
    public Map<Integer,HippsPositionIF> buildLogic(ClaimIF claim, DataManagerIF dataManager) {
        Map<Integer,HippsPositionIF> retMap = super.buildLogic(claim, dataManager);
        HippsPosition1_v04223 newStep = new HippsPosition1_v04223(claim, dataManager);
        retMap.put(newStep.getOrder(), newStep);
        return retMap;
    }
    
    /**
     *
     * @param steps
     */
    @Override
    protected void executeLogic(Map<Integer,HippsPositionIF> steps) {

        // Execute steps sequentially
        for (Integer position : steps.keySet()) {
            HippsPositionIF step = steps.get(position);
            // Execute logic of each step
            boolean validated = step.validate();
            /*
             * "Strict" mode - do not calculate the next HIPPS position
             * if previous validation failed
             */
            if(validated) {
                step.calculate();
            } else {
                break;
            }
        }

    }
    
}
