/*
 * Decompiled with CFR 0.152.
 */
package com.utilities.nodes;

import com.modal.DiagnosisCode;
import com.modal.referenceTable.ClinicalGroups;
import com.modal.referenceTable.ComorbidityGroups;
import com.modal.referenceTable.ComorbidityInteractions;
import com.modal.referenceTable.Diagnosis;
import com.modal.referenceTable.DiagnosisSubchapters;
import com.modal.referenceTable.HIPPSStructure;
import com.modal.referenceTable.ReferenceTable;
import com.utilities.component.ComponentManager;
import gov.cms.hh.data.files.TableNames_EN;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.scene.control.Pagination;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;

public class TableManager {
    private static HashMap<TableNames_EN, ArrayList<Double>> columnWidths = new HashMap();

    public static void initDxTable(TableView<DiagnosisCode> tableView, ObservableList<DiagnosisCode> data) {
        TableColumn dxColumn = new TableColumn("Diagnosis");
        TableColumn poaColumn = new TableColumn("POA");
        TableColumn typeColumn = new TableColumn("Type");
        TableColumn descriptionColumn = new TableColumn("Description");
        TableManager.clearTable(tableView);
        dxColumn.setCellValueFactory(new PropertyValueFactory("diagnosis"));
        poaColumn.setCellValueFactory(new PropertyValueFactory("poa"));
        typeColumn.setCellValueFactory(new PropertyValueFactory("dxType"));
        descriptionColumn.setCellValueFactory(new PropertyValueFactory("description"));
        tableView.setItems(data);
        tableView.getColumns().addAll(dxColumn, poaColumn, typeColumn, descriptionColumn);
        tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        dxColumn.setResizable(false);
        poaColumn.setResizable(false);
        typeColumn.setResizable(false);
        descriptionColumn.setResizable(false);
        dxColumn.setSortable(false);
        poaColumn.setSortable(false);
        typeColumn.setSortable(false);
        descriptionColumn.setSortable(false);
        dxColumn.prefWidthProperty().bind(tableView.widthProperty().multiply(0.1));
        poaColumn.prefWidthProperty().bind(tableView.widthProperty().multiply(0.1));
        typeColumn.prefWidthProperty().bind(tableView.widthProperty().multiply(0.2));
        descriptionColumn.prefWidthProperty().bind(tableView.widthProperty().multiply(0.7));
        poaColumn.setVisible(false);
    }

    public static <T> void initTable(TableView<T> tableView, ObservableList<T> data, String table, String[] filterValues, String previousSelection) {
        ReferenceTable t = null;
        TableNames_EN table_en = TableNames_EN.valueOf(table.replace(" ", "_"));
        if (previousSelection != null) {
            TableNames_EN previous_en = TableNames_EN.valueOf(previousSelection.replace(" ", "_"));
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (TableColumn tableColumn : tableView.getColumns()) {
                arrayList.add(tableColumn.getWidth());
            }
            columnWidths.put(previous_en, arrayList);
        }
        TableManager.clearTable(tableView);
        switch (TableNames_EN.valueOf(table.replace(" ", "_"))) {
            case Clinical_Groups: {
                t = new ClinicalGroups(data, filterValues);
                break;
            }
            case Comorbidity_Groups: {
                t = new ComorbidityGroups(data, filterValues);
                break;
            }
            case Comorbidity_Interactions: {
                t = new ComorbidityInteractions(data, filterValues);
                break;
            }
            case Diagnoses: {
                t = new Diagnosis(data, filterValues);
                break;
            }
            case Diagnosis_Subchapters: {
                t = new DiagnosisSubchapters(data, filterValues);
                break;
            }
            case HIPPS_Structure: {
                t = new HIPPSStructure(data, filterValues);
            }
        }
        tableView.getColumns().addAll(t.getTable().getColumns());
        for (Object e : t.getTable().getColumns()) {
            ((TableColumn)e).setSortable(false);
            ((TableColumn)e).setEditable(false);
            ((TableColumn)e).setReorderable(false);
            if (columnWidths.get(table_en) == null || tableView.getColumns().size() != columnWidths.get(table_en).size()) continue;
            ((TableColumn)e).setPrefWidth(columnWidths.get(table_en).set(tableView.getColumns().indexOf(e), ((TableColumn)tableView.getColumns().get(tableView.getColumns().indexOf(e))).getWidth()));
        }
        tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        tableView.setItems(t.getTable().getItems());
    }

    public static void setPagenation(Pagination pagenation, int size, double maxPerPage) {
        if (size > 0) {
            pagenation.setVisible(true);
            pagenation.setPageCount((double)size / maxPerPage == 0.0 ? 1 : (int)Math.ceil((double)size / maxPerPage));
            pagenation.setCurrentPageIndex(pagenation.getCurrentPageIndex());
        } else {
            pagenation.setVisible(false);
            pagenation.setPageCount(0);
            pagenation.setCurrentPageIndex(0);
        }
    }

    private static void exportToCSV(List<String[]> dataLines, String fileName) {
        File csvOutputFile = new File(fileName);
        try (PrintWriter pw = new PrintWriter(csvOutputFile);){
            dataLines.stream().map(TableManager::convertToCSV).forEach(pw::println);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static String convertToCSV(String[] data) {
        return Stream.of(data).map(TableManager::escapeSpecialCharacters).collect(Collectors.joining(","));
    }

    private static String escapeSpecialCharacters(String data) {
        Object escapedData = data.replaceAll("\\R", " ");
        if (data.contains(",") || data.contains("\"") || data.contains("'")) {
            data = data.replace("\"", "\"\"");
            escapedData = "\"" + data + "\"";
        }
        return escapedData;
    }

    public static void clearPage(Pagination p) {
        p.setVisible(false);
        p.setCurrentPageIndex(0);
        p.setPageCount(0);
    }

    public static void clearTable(TableView t) {
        t.getItems().clear();
        t.getColumns().clear();
    }

    public static void clearSelection(TableView t) {
        t.getSelectionModel().clearSelection();
    }

    public static void exportToCSV(ComponentManager componentManager, String pathToSave, boolean isFiltered) {
        ArrayList<String[]> tableLines = new ArrayList<String[]>();
        if (!isFiltered) {
            for (List list : componentManager.getUnfilteredTableData()) {
                TableManager.addRow(tableLines, list);
            }
        } else {
            for (Object e : componentManager.getFilteredRT()) {
                TableManager.addRow(tableLines, (List)e);
            }
        }
        TableManager.exportToCSV(tableLines, pathToSave);
    }

    private static void addRow(List<String[]> tableLines, List<String> referenceTableData) {
        String[] row = new String[referenceTableData.size()];
        for (int i = 0; i < referenceTableData.size(); ++i) {
            row[i] = referenceTableData.get(i);
        }
        tableLines.add(row);
    }

    public static String[] getFilterValues(TableView tableView) {
        String[] filterArray = new String[tableView.getColumns().size()];
        for (int i = 0; i < tableView.getColumns().size(); ++i) {
            filterArray[i] = ((TextField)((VBox)((TableColumn)tableView.getColumns().get(i)).getGraphic()).getChildren().get(1)).getText();
        }
        return filterArray;
    }

    public static TextField[] getFilterTextFields(TableView tableView) {
        TextField[] filterArray = new TextField[tableView.getColumns().size()];
        for (int i = 0; i < tableView.getColumns().size(); ++i) {
            filterArray[i] = (TextField)((VBox)((TableColumn)tableView.getColumns().get(i)).getGraphic()).getChildren().get(1);
        }
        return filterArray;
    }
}

