/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.claim.ClaimElementBase;
import gov.cms.hh.diagnosis.ClinicalGroupIF;
import gov.cms.hh.diagnosis.CodeFirstConditionIF;
import gov.cms.hh.diagnosis.ComorbidityGroupIF;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.diagnosis.DiagnosisSubchapterIF;
import gov.cms.hh.reference.objects.DiagnosisObject;

public class Diagnosis
extends ClaimElementBase
implements DiagnosisIF {
    private static final long serialVersionUID = 1L;
    private int id;
    private String value;
    private String description;
    private boolean manifestation;
    private boolean primaryAwarding;
    private boolean ECOI;
    private boolean codeFirst;
    private boolean unacceptablePdx;
    private boolean unspecifiedPdx;
    private String predecessor;
    private ClinicalGroupIF clinicalGroup;
    private ComorbidityGroupIF comorbidityGroup;
    private DiagnosisSubchapterIF diagnosisSubchapter;
    private CodeFirstConditionIF codeFirstCondition;
    private int codeFistConditionId;

    @Override
    public String getPredecessor() {
        return this.predecessor;
    }

    @Override
    public void setPredecessor(String predecessor) {
        this.predecessor = predecessor;
    }

    @Override
    public CodeFirstConditionIF getCodeFirstCondition() {
        return this.codeFirstCondition;
    }

    @Override
    public void setCodeFirstCondition(CodeFirstConditionIF codeFirstCondition) {
        this.codeFirstCondition = codeFirstCondition;
    }

    @Override
    public boolean isCodeFirst() {
        return this.codeFirst;
    }

    @Override
    public void setCodeFirst(boolean codeFirst) {
        this.codeFirst = codeFirst;
    }

    @Override
    public boolean isUnacceptablePdx() {
        return this.unacceptablePdx;
    }

    @Override
    public void setUnacceptablePdx(boolean unacceptablePdx) {
        this.unacceptablePdx = unacceptablePdx;
    }

    public String toString() {
        return "Diagnosis{id=" + this.id + ", value=" + this.value + ", description=" + this.description + ", manifestation=" + this.manifestation + ", primaryAwarding=" + this.primaryAwarding + ", ECOI=" + this.ECOI + ", codeFirst=" + this.codeFirst + ", unacceptablePdx=" + this.unacceptablePdx + ", clinicalGroup=" + this.clinicalGroup + ", comorbidityGroup=" + this.comorbidityGroup + ", diagnosisSubchapter=" + this.diagnosisSubchapter + ", codeFirstCondition=" + this.codeFirstCondition + ", predecessor=" + this.predecessor + "}";
    }

    public Diagnosis() {
    }

    public Diagnosis(int id, String value, String description, boolean manifestation, boolean primaryAwarding, boolean ECOI, boolean codeFirst, boolean unacceptablePdx, boolean unspecifiedPdx, String predecessor, ClinicalGroupIF clinicalGroup, ComorbidityGroupIF comorbidityGroup, DiagnosisSubchapterIF diagnosisSubchapter) {
        this.id = id;
        this.value = value;
        this.description = description;
        this.manifestation = manifestation;
        this.primaryAwarding = primaryAwarding;
        this.ECOI = ECOI;
        this.codeFirst = codeFirst;
        this.unacceptablePdx = unacceptablePdx;
        this.unspecifiedPdx = unspecifiedPdx;
        this.predecessor = predecessor;
        this.clinicalGroup = clinicalGroup;
        this.comorbidityGroup = comorbidityGroup;
        this.diagnosisSubchapter = diagnosisSubchapter;
    }

    public Diagnosis(int id, DiagnosisObject diagObj, ClinicalGroupIF clinicalGroup, ComorbidityGroupIF comorbidityGroup, DiagnosisSubchapterIF diagnosisSubchapter) {
        this(id, diagObj.getValue(), diagObj.getDescription(), Integer.parseInt(diagObj.getManifestationFlag()) > 0, Integer.parseInt(diagObj.getPrimaryAwardingFlag()) > 0, Integer.parseInt(diagObj.getEcoiFlag()) > 0, Integer.parseInt(diagObj.getCodeFirstFlag()) > 0, Integer.parseInt(diagObj.getUnacceptablePdxFlag()) > 0, Integer.parseInt(diagObj.getUnspecifiedPdxFlag()) > 0, diagObj.getPredecessorDx(), clinicalGroup, comorbidityGroup, diagnosisSubchapter);
        this.codeFistConditionId = Integer.parseInt(diagObj.getCodeFirstFlag());
    }

    public Diagnosis(int id, DiagnosisObject diagObj, ClinicalGroupIF clinicalGroup, ComorbidityGroupIF comorbidityGroup, DiagnosisSubchapterIF diagnosisSubchapter, CodeFirstConditionIF codeFirstCondition) {
        this(id, diagObj, clinicalGroup, comorbidityGroup, diagnosisSubchapter);
        this.codeFirstCondition = codeFirstCondition;
    }

    @Override
    public ClinicalGroupIF getClinicalGroup() {
        return this.clinicalGroup;
    }

    @Override
    public void setClinicalGroup(ClinicalGroupIF clinicalGroup) {
        this.clinicalGroup = clinicalGroup;
    }

    @Override
    public ComorbidityGroupIF getComorbidityGroup() {
        return this.comorbidityGroup;
    }

    @Override
    public void setComorbidityGroup(ComorbidityGroupIF comorbidityGroup) {
        this.comorbidityGroup = comorbidityGroup;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isManifestation() {
        return this.manifestation;
    }

    @Override
    public void setManifestation(boolean manifestation) {
        this.manifestation = manifestation;
    }

    @Override
    public boolean isPrimaryAwarding() {
        return this.primaryAwarding;
    }

    @Override
    public void setPrimaryAwarding(boolean primaryAwarding) {
        this.primaryAwarding = primaryAwarding;
    }

    @Override
    public boolean isECOI() {
        return this.ECOI;
    }

    @Override
    public void setECOI(boolean ECOI) {
        this.ECOI = ECOI;
    }

    @Override
    public DiagnosisSubchapterIF getDiagnosisSubchapter() {
        return this.diagnosisSubchapter;
    }

    @Override
    public void setDiagnosisSubchapter(DiagnosisSubchapterIF diagnosisSubchapter) {
        this.diagnosisSubchapter = diagnosisSubchapter;
    }

    @Override
    public boolean isUnspecifiedPdx() {
        return this.unspecifiedPdx;
    }

    @Override
    public void setUnspecifiedPdx(boolean unspecifiedPdx) {
        this.unspecifiedPdx = unspecifiedPdx;
    }

    @Override
    public int getCodeFistConditionId() {
        return this.codeFistConditionId;
    }

    @Override
    public void setCodeFistConditionId(int codeFistConditionId) {
        this.codeFistConditionId = codeFistConditionId;
    }
}

