/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.reference.objects.ReturnCodeObject;
import java.text.ParseException;

/**
 *
 * @author CMS
 */
public class ReturnCode implements ReturnCodeIF {

    private static final long serialVersionUID = 1L;
    
    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "ReturnCode{" + "id=" + id + ", description=" + description + '}';
    }

    /**
     * Constructor
     */
    public ReturnCode() {
    }

    /**
     *
     * @param rco
     * @throws ParseException
     */
    public ReturnCode(ReturnCodeObject rco) throws ParseException {
        this.id = Integer.parseInt(rco.getCode());
        this.description = rco.getDescription();
    }
    
    /**
     *
     * @param id
     * @param description
     */
    public ReturnCode(int id, String description) {
        this.id = id;
        this.description = description;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }
    
    private int id;
    private String description;
    
}
