/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.diagnosis;

/**
 *
 * @author CMS
 */
public class ComorbidityInteraction implements ComorbidityInteractionIF {

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "ComorbidityInteraction{" + "id=" + id + ", comorbidityGroup1=" + comorbidityGroup1 + ", comorbidityGroup2=" + comorbidityGroup2 + '}';
    }

    /**
     *
     * @param id
     * @param comorbidityGroup1
     * @param comorbidityGroup2
     */
    public ComorbidityInteraction(int id, ComorbidityGroupIF comorbidityGroup1, ComorbidityGroupIF comorbidityGroup2) {
        this.id = id;
        this.comorbidityGroup1 = comorbidityGroup1;
        this.comorbidityGroup2 = comorbidityGroup2;
    }

    /**
     * Constructor
     */
    public ComorbidityInteraction() {
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the comorbidityGroup1
     */
    @Override
    public ComorbidityGroupIF getComorbidityGroup1() {
        return comorbidityGroup1;
    }

    /**
     * @param comorbidityGroup1 the comorbidityGroup1 to set
     */
    @Override
    public void setComorbidityGroup1(ComorbidityGroupIF comorbidityGroup1) {
        this.comorbidityGroup1 = comorbidityGroup1;
    }

    /**
     * @return the comorbidityGroup2
     */
    @Override
    public ComorbidityGroupIF getComorbidityGroup2() {
        return comorbidityGroup2;
    }

    /**
     * @param comorbidityGroup2 the comorbidityGroup2 to set
     */
    @Override
    public void setComorbidityGroup2(ComorbidityGroupIF comorbidityGroup2) {
        this.comorbidityGroup2 = comorbidityGroup2;
    }
    private int id;
    private ComorbidityGroupIF comorbidityGroup1;
    private ComorbidityGroupIF comorbidityGroup2;
}
