/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.reference.objects;

import gov.cms.hh.data.loader.PositionAccessorIF;
import gov.cms.hh.xml.layout.rot.CodeFirstCondition;

/**
 *
 * @author CMS
 */
public class CodeFirstConditionObject extends CodeFirstCondition implements PositionAccessorIF {

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "Code First Condition ID:'" + getId() +
                "', Description:'" + getDescription() +
                "', Condition Range:'" + getRange() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getId();
            case 1:
                return getDescription();
            case 2:
                return getRange();
            default:
                return null; // Exception???
        }
    }

    /**
     *
     * @param position
     * @param value
     * @return
     */
    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setId(value);
                return true;
            case 1:
                setDescription(value);
                return true;
            case 2:
                setRange(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 3;
    }
    
    /**
     *
     * @param value
     */
    @Override
    public void setDescription(String value) {
        if (isLoadDescription()) {
            super.setDescription(value);
        }
    }

    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }
    
}
