// Generated by delombok at Mon Dec 08 20:50:48 UTC 2025
package gov.cms.fiss.pricers.opps.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

@Schema(description = "The IOCE service line information.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-OCE-LINE", value = "<structure>"), @ExtensionProperty(name = "OCE-IN-LINES", value = "<structure>")})})
public class IoceServiceLineData {
  @Pattern(regexp = "[A-Z\\d]", message = "must be alphanumeric")
  @Schema(description = "The flag that identifies an override to a line item denial/rejection or to allow the " + "MAC to indicate the line item should be denied/rejected.", example = "1", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-LITEM-ACT-FLAG", value = "PIC X(01)")})})
  private String actionFlag;
  @Max(999999999)
  @Min(0)
  @Schema(description = "The quantitative measure of services rendered to or for the patient by Healthcare " + "Common Procedure Coding System (HCPCS) code.", example = "1827", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-SRVC-UNITS", value = "PIC 9(09)")})})
  private int apcServiceUnits;
  @Pattern(regexp = "\\d{2}", message = "must be two digits")
  @Schema(description = "The composite adjustment flag.", example = "00", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-COMP-ADJ-FLAG", value = "PIC X(02)")})})
  private String compositeAdjustmentFlag;
  @BigDecimalScale
  @DecimalMax("99999999.99")
  @DecimalMin("0")
  @Digits(integer = 8, fraction = 2)
  @Schema(description = "The charges related to the revenue or Healthcare Common Procedure Coding System " + "(HCPCS) procedure codes for the current billing period.", example = "93845.23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-SUB-CHRG", value = "PIC 9(08)V99")})})
  private BigDecimal coveredCharges = BigDecimalUtils.ZERO;
  @Schema(description = "The date of service.", example = "2020-05-13", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-LITEM-DOS", value = "PIC 9(08)")})})
  @StrictLocalDate
  private LocalDate dateOfService;
  @Pattern(regexp = "[A-Z\\d]", message = "must be alphanumeric")
  @Schema(description = "The indicator that signifies if the line item was denied or rejected.", example = "0", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-LITEM-DR-FLAG", value = "PIC X(01)")})})
  private String denyOrRejectFlag;
  @Max(9)
  @Min(0)
  @Schema(description = "The identifier of the discounting formula that was applied.", example = "1", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-DISC-FACT", value = "PIC 9(01)")})})
  private int discountingFormula;
  @Pattern(regexp = "\\d{5}", message = "must be five digits")
  @Schema(description = "The ambulatory payment classification (APC) assigned to the HCPCS procedure code.", example = "05521", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-HCPCS-APC", value = "PIC X(05)")})})
  private String hcpcsApc;
  @Pattern(regexp = "[A-Z\\d]{5}", message = "must be five alphanumeric characters")
  @Schema(description = "The Healthcare Common Procedure Coding System (HCPCS) code associated with " + "the procedure.", example = "70551", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-HCPCS", value = "PIC X(05)")})})
  private String hcpcsCode;
  @ArraySchema(arraySchema = @Schema(description = "The Healthcare Common Procedure Coding System (HCPCS) code modifiers.", example = "[\"95\", \"99\"]"), uniqueItems = true)
  @Size(max = 6, min = 1)
  private List<@Pattern(regexp = "@[A-Z\\d]|[A-Z\\d]{2}|#[A-Z\\d]", message = "must be two alphanumeric characters, or a \'@\' followed by an alphanumeric " + "character, or a \'#\' followed by an alphanumeric character.") String> hcpcsModifiers;
  @Max(450)
  @Min(1)
  @NotNull
  @Schema(description = "The index of the service line within the claim data.")
  private Integer lineNumber;
  @Pattern(regexp = "\\d", message = "must be a digit")
  @Schema(description = "The flag that identifies the inclusion of certain ancillary services performed as part " + "of a visit into the APC payment rate for a significant procedure or medical " + "visit.", example = "3", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-PKG-FLAG", value = "PIC X(01)")})})
  private String packageFlag;
  @ArraySchema(arraySchema = @Schema(description = "The flags that identify the type of payment adjustment(s) applied.", example = "[\"1\",\"23\"]", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-PYMT-ADJ-FLAG", value = "PIC X(02)")})}), uniqueItems = true)
  @Size(max = 2, min = 1)
  private List<@NotNull @Pattern(regexp = "\\d{1,2}", message = "must be one or two digits") String> paymentAdjustmentFlags;
  @Pattern(regexp = "\\d{5}", message = "must be five digits")
  @Schema(description = "The ambulatory payment classification (APC) assigned for payment.", example = "05523", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-GRP", value = "PIC X(05)")})})
  private String paymentApc = "00000";
  @Pattern(regexp = "\\d{1,2}", message = "must be one or two digits")
  @Schema(description = "The indicator that signifies whether the service payment was made in whole, in part or" + " denied.", example = "5", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-PYMT-IND", value = "PIC X(02)")})})
  private String paymentIndicator;
  @Pattern(regexp = "[A-Z\\d]", message = "must be a digit or upper-case letter")
  @Schema(description = "The payment method flag denoting how the payment was determined.", example = "0", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-SITE-SRVC-FLAG", value = "PIC X(01)")})})
  private String paymentMethodFlag;
  @NotNull
  @Pattern(regexp = "\\d{4}", message = "must be four digits")
  @Schema(description = "The code that identifies a specific accommodation, ancillary service, or billing " + "calculation.", example = "0320", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-LITEM-RVCD", value = "PIC X(04)")})})
  private String revenueCode;
  @Pattern(regexp = "[A-Z]\\d?", message = "must be one alphanumeric character optionally followed by a digit")
  @Schema(description = "The indicator that signifies whether Medicare will reimburse the service and how it " + "will be reimbursed. The indicator also helps in determining whether policy rules " + "(such as packaging and discounting) apply.", example = "J1", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OPPS-SRVC-IND", value = "PIC X(02)")})})
  private String statusIndicator;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getActionFlag() {
    return this.actionFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getApcServiceUnits() {
    return this.apcServiceUnits;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCompositeAdjustmentFlag() {
    return this.compositeAdjustmentFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCoveredCharges() {
    return this.coveredCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getDateOfService() {
    return this.dateOfService;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDenyOrRejectFlag() {
    return this.denyOrRejectFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getDiscountingFormula() {
    return this.discountingFormula;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHcpcsApc() {
    return this.hcpcsApc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHcpcsCode() {
    return this.hcpcsCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "@[A-Z\\d]|[A-Z\\d]{2}|#[A-Z\\d]", message = "must be two alphanumeric characters, or a \'@\' followed by an alphanumeric " + "character, or a \'#\' followed by an alphanumeric character.") String> getHcpcsModifiers() {
    return this.hcpcsModifiers;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getLineNumber() {
    return this.lineNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPackageFlag() {
    return this.packageFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@NotNull @Pattern(regexp = "\\d{1,2}", message = "must be one or two digits") String> getPaymentAdjustmentFlags() {
    return this.paymentAdjustmentFlags;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPaymentApc() {
    return this.paymentApc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPaymentIndicator() {
    return this.paymentIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPaymentMethodFlag() {
    return this.paymentMethodFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRevenueCode() {
    return this.revenueCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatusIndicator() {
    return this.statusIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActionFlag(final String actionFlag) {
    this.actionFlag = actionFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApcServiceUnits(final int apcServiceUnits) {
    this.apcServiceUnits = apcServiceUnits;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCompositeAdjustmentFlag(final String compositeAdjustmentFlag) {
    this.compositeAdjustmentFlag = compositeAdjustmentFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoveredCharges(final BigDecimal coveredCharges) {
    this.coveredCharges = coveredCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDateOfService(final LocalDate dateOfService) {
    this.dateOfService = dateOfService;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDenyOrRejectFlag(final String denyOrRejectFlag) {
    this.denyOrRejectFlag = denyOrRejectFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiscountingFormula(final int discountingFormula) {
    this.discountingFormula = discountingFormula;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHcpcsApc(final String hcpcsApc) {
    this.hcpcsApc = hcpcsApc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHcpcsCode(final String hcpcsCode) {
    this.hcpcsCode = hcpcsCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHcpcsModifiers(final List<@Pattern(regexp = "@[A-Z\\d]|[A-Z\\d]{2}|#[A-Z\\d]", message = "must be two alphanumeric characters, or a \'@\' followed by an alphanumeric " + "character, or a \'#\' followed by an alphanumeric character.") String> hcpcsModifiers) {
    this.hcpcsModifiers = hcpcsModifiers;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLineNumber(final Integer lineNumber) {
    this.lineNumber = lineNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPackageFlag(final String packageFlag) {
    this.packageFlag = packageFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentAdjustmentFlags(final List<@NotNull @Pattern(regexp = "\\d{1,2}", message = "must be one or two digits") String> paymentAdjustmentFlags) {
    this.paymentAdjustmentFlags = paymentAdjustmentFlags;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentApc(final String paymentApc) {
    this.paymentApc = paymentApc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentIndicator(final String paymentIndicator) {
    this.paymentIndicator = paymentIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodFlag(final String paymentMethodFlag) {
    this.paymentMethodFlag = paymentMethodFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRevenueCode(final String revenueCode) {
    this.revenueCode = revenueCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusIndicator(final String statusIndicator) {
    this.statusIndicator = statusIndicator;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof IoceServiceLineData)) return false;
    final IoceServiceLineData other = (IoceServiceLineData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (this.getApcServiceUnits() != other.getApcServiceUnits()) return false;
    if (this.getDiscountingFormula() != other.getDiscountingFormula()) return false;
    final java.lang.Object this$lineNumber = this.getLineNumber();
    final java.lang.Object other$lineNumber = other.getLineNumber();
    if (this$lineNumber == null ? other$lineNumber != null : !this$lineNumber.equals(other$lineNumber)) return false;
    final java.lang.Object this$actionFlag = this.getActionFlag();
    final java.lang.Object other$actionFlag = other.getActionFlag();
    if (this$actionFlag == null ? other$actionFlag != null : !this$actionFlag.equals(other$actionFlag)) return false;
    final java.lang.Object this$compositeAdjustmentFlag = this.getCompositeAdjustmentFlag();
    final java.lang.Object other$compositeAdjustmentFlag = other.getCompositeAdjustmentFlag();
    if (this$compositeAdjustmentFlag == null ? other$compositeAdjustmentFlag != null : !this$compositeAdjustmentFlag.equals(other$compositeAdjustmentFlag)) return false;
    final java.lang.Object this$coveredCharges = this.getCoveredCharges();
    final java.lang.Object other$coveredCharges = other.getCoveredCharges();
    if (this$coveredCharges == null ? other$coveredCharges != null : !this$coveredCharges.equals(other$coveredCharges)) return false;
    final java.lang.Object this$dateOfService = this.getDateOfService();
    final java.lang.Object other$dateOfService = other.getDateOfService();
    if (this$dateOfService == null ? other$dateOfService != null : !this$dateOfService.equals(other$dateOfService)) return false;
    final java.lang.Object this$denyOrRejectFlag = this.getDenyOrRejectFlag();
    final java.lang.Object other$denyOrRejectFlag = other.getDenyOrRejectFlag();
    if (this$denyOrRejectFlag == null ? other$denyOrRejectFlag != null : !this$denyOrRejectFlag.equals(other$denyOrRejectFlag)) return false;
    final java.lang.Object this$hcpcsApc = this.getHcpcsApc();
    final java.lang.Object other$hcpcsApc = other.getHcpcsApc();
    if (this$hcpcsApc == null ? other$hcpcsApc != null : !this$hcpcsApc.equals(other$hcpcsApc)) return false;
    final java.lang.Object this$hcpcsCode = this.getHcpcsCode();
    final java.lang.Object other$hcpcsCode = other.getHcpcsCode();
    if (this$hcpcsCode == null ? other$hcpcsCode != null : !this$hcpcsCode.equals(other$hcpcsCode)) return false;
    final java.lang.Object this$hcpcsModifiers = this.getHcpcsModifiers();
    final java.lang.Object other$hcpcsModifiers = other.getHcpcsModifiers();
    if (this$hcpcsModifiers == null ? other$hcpcsModifiers != null : !this$hcpcsModifiers.equals(other$hcpcsModifiers)) return false;
    final java.lang.Object this$packageFlag = this.getPackageFlag();
    final java.lang.Object other$packageFlag = other.getPackageFlag();
    if (this$packageFlag == null ? other$packageFlag != null : !this$packageFlag.equals(other$packageFlag)) return false;
    final java.lang.Object this$paymentAdjustmentFlags = this.getPaymentAdjustmentFlags();
    final java.lang.Object other$paymentAdjustmentFlags = other.getPaymentAdjustmentFlags();
    if (this$paymentAdjustmentFlags == null ? other$paymentAdjustmentFlags != null : !this$paymentAdjustmentFlags.equals(other$paymentAdjustmentFlags)) return false;
    final java.lang.Object this$paymentApc = this.getPaymentApc();
    final java.lang.Object other$paymentApc = other.getPaymentApc();
    if (this$paymentApc == null ? other$paymentApc != null : !this$paymentApc.equals(other$paymentApc)) return false;
    final java.lang.Object this$paymentIndicator = this.getPaymentIndicator();
    final java.lang.Object other$paymentIndicator = other.getPaymentIndicator();
    if (this$paymentIndicator == null ? other$paymentIndicator != null : !this$paymentIndicator.equals(other$paymentIndicator)) return false;
    final java.lang.Object this$paymentMethodFlag = this.getPaymentMethodFlag();
    final java.lang.Object other$paymentMethodFlag = other.getPaymentMethodFlag();
    if (this$paymentMethodFlag == null ? other$paymentMethodFlag != null : !this$paymentMethodFlag.equals(other$paymentMethodFlag)) return false;
    final java.lang.Object this$revenueCode = this.getRevenueCode();
    final java.lang.Object other$revenueCode = other.getRevenueCode();
    if (this$revenueCode == null ? other$revenueCode != null : !this$revenueCode.equals(other$revenueCode)) return false;
    final java.lang.Object this$statusIndicator = this.getStatusIndicator();
    final java.lang.Object other$statusIndicator = other.getStatusIndicator();
    if (this$statusIndicator == null ? other$statusIndicator != null : !this$statusIndicator.equals(other$statusIndicator)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof IoceServiceLineData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    result = result * PRIME + this.getApcServiceUnits();
    result = result * PRIME + this.getDiscountingFormula();
    final java.lang.Object $lineNumber = this.getLineNumber();
    result = result * PRIME + ($lineNumber == null ? 43 : $lineNumber.hashCode());
    final java.lang.Object $actionFlag = this.getActionFlag();
    result = result * PRIME + ($actionFlag == null ? 43 : $actionFlag.hashCode());
    final java.lang.Object $compositeAdjustmentFlag = this.getCompositeAdjustmentFlag();
    result = result * PRIME + ($compositeAdjustmentFlag == null ? 43 : $compositeAdjustmentFlag.hashCode());
    final java.lang.Object $coveredCharges = this.getCoveredCharges();
    result = result * PRIME + ($coveredCharges == null ? 43 : $coveredCharges.hashCode());
    final java.lang.Object $dateOfService = this.getDateOfService();
    result = result * PRIME + ($dateOfService == null ? 43 : $dateOfService.hashCode());
    final java.lang.Object $denyOrRejectFlag = this.getDenyOrRejectFlag();
    result = result * PRIME + ($denyOrRejectFlag == null ? 43 : $denyOrRejectFlag.hashCode());
    final java.lang.Object $hcpcsApc = this.getHcpcsApc();
    result = result * PRIME + ($hcpcsApc == null ? 43 : $hcpcsApc.hashCode());
    final java.lang.Object $hcpcsCode = this.getHcpcsCode();
    result = result * PRIME + ($hcpcsCode == null ? 43 : $hcpcsCode.hashCode());
    final java.lang.Object $hcpcsModifiers = this.getHcpcsModifiers();
    result = result * PRIME + ($hcpcsModifiers == null ? 43 : $hcpcsModifiers.hashCode());
    final java.lang.Object $packageFlag = this.getPackageFlag();
    result = result * PRIME + ($packageFlag == null ? 43 : $packageFlag.hashCode());
    final java.lang.Object $paymentAdjustmentFlags = this.getPaymentAdjustmentFlags();
    result = result * PRIME + ($paymentAdjustmentFlags == null ? 43 : $paymentAdjustmentFlags.hashCode());
    final java.lang.Object $paymentApc = this.getPaymentApc();
    result = result * PRIME + ($paymentApc == null ? 43 : $paymentApc.hashCode());
    final java.lang.Object $paymentIndicator = this.getPaymentIndicator();
    result = result * PRIME + ($paymentIndicator == null ? 43 : $paymentIndicator.hashCode());
    final java.lang.Object $paymentMethodFlag = this.getPaymentMethodFlag();
    result = result * PRIME + ($paymentMethodFlag == null ? 43 : $paymentMethodFlag.hashCode());
    final java.lang.Object $revenueCode = this.getRevenueCode();
    result = result * PRIME + ($revenueCode == null ? 43 : $revenueCode.hashCode());
    final java.lang.Object $statusIndicator = this.getStatusIndicator();
    result = result * PRIME + ($statusIndicator == null ? 43 : $statusIndicator.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "IoceServiceLineData(actionFlag=" + this.getActionFlag() + ", apcServiceUnits=" + this.getApcServiceUnits() + ", compositeAdjustmentFlag=" + this.getCompositeAdjustmentFlag() + ", coveredCharges=" + this.getCoveredCharges() + ", dateOfService=" + this.getDateOfService() + ", denyOrRejectFlag=" + this.getDenyOrRejectFlag() + ", discountingFormula=" + this.getDiscountingFormula() + ", hcpcsApc=" + this.getHcpcsApc() + ", hcpcsCode=" + this.getHcpcsCode() + ", hcpcsModifiers=" + this.getHcpcsModifiers() + ", lineNumber=" + this.getLineNumber() + ", packageFlag=" + this.getPackageFlag() + ", paymentAdjustmentFlags=" + this.getPaymentAdjustmentFlags() + ", paymentApc=" + this.getPaymentApc() + ", paymentIndicator=" + this.getPaymentIndicator() + ", paymentMethodFlag=" + this.getPaymentMethodFlag() + ", revenueCode=" + this.getRevenueCode() + ", statusIndicator=" + this.getStatusIndicator() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IoceServiceLineData() {
  }
}
