// Generated by delombok at Mon Dec 08 20:50:48 UTC 2025
package gov.cms.fiss.pricers.opps.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

@Schema(description = "The billing information associated with the claim.")
public class OppsClaimData extends ClaimData {
  @Max(9)
  @Min(0)
  @Schema(description = "The number of blood pints allowed for deductibles.", example = "3", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BENE-BLOOD-PINTS", value = "PIC 9(01)")})})
  private int bloodPintsRemaining;
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @Schema(description = "The device credit applied to the claim.", example = "8734.56", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-DEVICE-CREDIT", value = "PIC 9(09)V9(02)")})})
  private BigDecimal deviceCredit;
  @ArraySchema(arraySchema = @Schema(description = "The IOCE service lines.", required = true), uniqueItems = true, extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OCE-DATA", value = "OPPS-OCE-LINE OCCURS 450 TIMES"), @ExtensionProperty(name = "OCE-IN-DATE", value = "OCE-IN-LINES OCCURS 450 TIMES")})})
  @NotEmpty
  @Size(max = 450)
  @Valid
  private List<@NotNull IoceServiceLineData> ioceServiceLines;
  @BigDecimalScale
  @DecimalMax("99999999999.99")
  @DecimalMin("0")
  @Digits(integer = 11, fraction = 2)
  @Schema(description = "The patient\'s deductible.", example = "30043568744.23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BENE-DEDUCT", value = "PIC 9(11)V9(02)")})})
  private BigDecimal patientDeductible;
  @Valid
  private PayerOnlyValueCodeOffsetData payerOnlyValueCodeOffsets = new PayerOnlyValueCodeOffsetData();
  @BigDecimalScale
  @DecimalMax("9999999999.99")
  @DecimalMin("0")
  @Digits(integer = 10, fraction = 2)
  @Schema(description = "The prior outlier payment total.", example = "256060.93", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-PRIOR-OUTL-TOTAL", value = "PIC 9(10)V9(02)")})})
  private BigDecimal priorOutlierTotal = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @DecimalMax("9999999999.99")
  @DecimalMin("0")
  @Digits(integer = 10, fraction = 2)
  @Schema(description = "The prior payment total.", example = "983745.33", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-PRIOR-PYMT-TOTAL", value = "PIC 9(10)V9(02)")})})
  private BigDecimal priorPaymentTotal = BigDecimalUtils.ZERO;
  @NotNull
  @Schema(description = "The start date of service.", example = "2020-05-13", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-SERVICE-FROM-DATE", value = "PIC 9(08)")})})
  @StrictLocalDate
  private LocalDate serviceFromDate;
  @NotNull
  @Pattern(regexp = "[A-Z\\d]{3}", message = "must be three alphanumeric characters")
  @Schema(description = "The code indicating the specific type of bill: inpatient, outpatient, adjustments, " + "voids, etc.", example = "137", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-TYPE-OF-BILL", value = "PIC X(03)")})})
  private String typeOfBill;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getBloodPintsRemaining() {
    return this.bloodPintsRemaining;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDeviceCredit() {
    return this.deviceCredit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@NotNull IoceServiceLineData> getIoceServiceLines() {
    return this.ioceServiceLines;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPatientDeductible() {
    return this.patientDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PayerOnlyValueCodeOffsetData getPayerOnlyValueCodeOffsets() {
    return this.payerOnlyValueCodeOffsets;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPriorOutlierTotal() {
    return this.priorOutlierTotal;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPriorPaymentTotal() {
    return this.priorPaymentTotal;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getServiceFromDate() {
    return this.serviceFromDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTypeOfBill() {
    return this.typeOfBill;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBloodPintsRemaining(final int bloodPintsRemaining) {
    this.bloodPintsRemaining = bloodPintsRemaining;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeviceCredit(final BigDecimal deviceCredit) {
    this.deviceCredit = deviceCredit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIoceServiceLines(final List<@NotNull IoceServiceLineData> ioceServiceLines) {
    this.ioceServiceLines = ioceServiceLines;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientDeductible(final BigDecimal patientDeductible) {
    this.patientDeductible = patientDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayerOnlyValueCodeOffsets(final PayerOnlyValueCodeOffsetData payerOnlyValueCodeOffsets) {
    this.payerOnlyValueCodeOffsets = payerOnlyValueCodeOffsets;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPriorOutlierTotal(final BigDecimal priorOutlierTotal) {
    this.priorOutlierTotal = priorOutlierTotal;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPriorPaymentTotal(final BigDecimal priorPaymentTotal) {
    this.priorPaymentTotal = priorPaymentTotal;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceFromDate(final LocalDate serviceFromDate) {
    this.serviceFromDate = serviceFromDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTypeOfBill(final String typeOfBill) {
    this.typeOfBill = typeOfBill;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof OppsClaimData)) return false;
    final OppsClaimData other = (OppsClaimData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    if (this.getBloodPintsRemaining() != other.getBloodPintsRemaining()) return false;
    final java.lang.Object this$deviceCredit = this.getDeviceCredit();
    final java.lang.Object other$deviceCredit = other.getDeviceCredit();
    if (this$deviceCredit == null ? other$deviceCredit != null : !this$deviceCredit.equals(other$deviceCredit)) return false;
    final java.lang.Object this$ioceServiceLines = this.getIoceServiceLines();
    final java.lang.Object other$ioceServiceLines = other.getIoceServiceLines();
    if (this$ioceServiceLines == null ? other$ioceServiceLines != null : !this$ioceServiceLines.equals(other$ioceServiceLines)) return false;
    final java.lang.Object this$patientDeductible = this.getPatientDeductible();
    final java.lang.Object other$patientDeductible = other.getPatientDeductible();
    if (this$patientDeductible == null ? other$patientDeductible != null : !this$patientDeductible.equals(other$patientDeductible)) return false;
    final java.lang.Object this$payerOnlyValueCodeOffsets = this.getPayerOnlyValueCodeOffsets();
    final java.lang.Object other$payerOnlyValueCodeOffsets = other.getPayerOnlyValueCodeOffsets();
    if (this$payerOnlyValueCodeOffsets == null ? other$payerOnlyValueCodeOffsets != null : !this$payerOnlyValueCodeOffsets.equals(other$payerOnlyValueCodeOffsets)) return false;
    final java.lang.Object this$priorOutlierTotal = this.getPriorOutlierTotal();
    final java.lang.Object other$priorOutlierTotal = other.getPriorOutlierTotal();
    if (this$priorOutlierTotal == null ? other$priorOutlierTotal != null : !this$priorOutlierTotal.equals(other$priorOutlierTotal)) return false;
    final java.lang.Object this$priorPaymentTotal = this.getPriorPaymentTotal();
    final java.lang.Object other$priorPaymentTotal = other.getPriorPaymentTotal();
    if (this$priorPaymentTotal == null ? other$priorPaymentTotal != null : !this$priorPaymentTotal.equals(other$priorPaymentTotal)) return false;
    final java.lang.Object this$serviceFromDate = this.getServiceFromDate();
    final java.lang.Object other$serviceFromDate = other.getServiceFromDate();
    if (this$serviceFromDate == null ? other$serviceFromDate != null : !this$serviceFromDate.equals(other$serviceFromDate)) return false;
    final java.lang.Object this$typeOfBill = this.getTypeOfBill();
    final java.lang.Object other$typeOfBill = other.getTypeOfBill();
    if (this$typeOfBill == null ? other$typeOfBill != null : !this$typeOfBill.equals(other$typeOfBill)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof OppsClaimData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    result = result * PRIME + this.getBloodPintsRemaining();
    final java.lang.Object $deviceCredit = this.getDeviceCredit();
    result = result * PRIME + ($deviceCredit == null ? 43 : $deviceCredit.hashCode());
    final java.lang.Object $ioceServiceLines = this.getIoceServiceLines();
    result = result * PRIME + ($ioceServiceLines == null ? 43 : $ioceServiceLines.hashCode());
    final java.lang.Object $patientDeductible = this.getPatientDeductible();
    result = result * PRIME + ($patientDeductible == null ? 43 : $patientDeductible.hashCode());
    final java.lang.Object $payerOnlyValueCodeOffsets = this.getPayerOnlyValueCodeOffsets();
    result = result * PRIME + ($payerOnlyValueCodeOffsets == null ? 43 : $payerOnlyValueCodeOffsets.hashCode());
    final java.lang.Object $priorOutlierTotal = this.getPriorOutlierTotal();
    result = result * PRIME + ($priorOutlierTotal == null ? 43 : $priorOutlierTotal.hashCode());
    final java.lang.Object $priorPaymentTotal = this.getPriorPaymentTotal();
    result = result * PRIME + ($priorPaymentTotal == null ? 43 : $priorPaymentTotal.hashCode());
    final java.lang.Object $serviceFromDate = this.getServiceFromDate();
    result = result * PRIME + ($serviceFromDate == null ? 43 : $serviceFromDate.hashCode());
    final java.lang.Object $typeOfBill = this.getTypeOfBill();
    result = result * PRIME + ($typeOfBill == null ? 43 : $typeOfBill.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "OppsClaimData(bloodPintsRemaining=" + this.getBloodPintsRemaining() + ", deviceCredit=" + this.getDeviceCredit() + ", ioceServiceLines=" + this.getIoceServiceLines() + ", patientDeductible=" + this.getPatientDeductible() + ", payerOnlyValueCodeOffsets=" + this.getPayerOnlyValueCodeOffsets() + ", priorOutlierTotal=" + this.getPriorOutlierTotal() + ", priorPaymentTotal=" + this.getPriorPaymentTotal() + ", serviceFromDate=" + this.getServiceFromDate() + ", typeOfBill=" + this.getTypeOfBill() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OppsClaimData() {
  }
}
