// Generated by delombok at Mon Dec 08 20:50:48 UTC 2025
package gov.cms.fiss.pricers.opps.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import java.math.BigDecimal;

@Schema(description = "The APC payment offset amounts for payer value codes.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-PAYER-ONLY-VALUE-CODES", value = "<structure>")})})
public class PayerOnlyValueCodeOffsetData {
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @Schema(description = "The APC payment offset amount for payer value code QN (APC device offset).", example = "98236.75", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-PAYER-ONLY-VC-QN", value = "PIC 9(09)V9(02)")})})
  private BigDecimal apcDeviceOffsetAmountQn;
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @Schema(description = "The APC payment offset amount for payer value code QO (additional APC device " + "offset).", example = "8079234.65", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-PAYER-ONLY-VC-QO", value = "PIC 9(09)V9(02)")})})
  private BigDecimal apcDeviceOffsetAmountQo;
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @Schema(description = "The APC payment offset amount for payer value code QU (condition for device credit " + "present).", example = "345906.87", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-PAYER-ONLY-VC-QU", value = "PIC 9(09)V9(02)")})})
  private BigDecimal deviceCreditCapOffsetAmountQu;
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @Schema(description = "The APC payment offset amount for payer value code QQ (terminated procedure with " + "pass-through device OR condition for device credit present).", example = "3454665.35", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-PAYER-ONLY-VC-QQ", value = "PIC 9(09)V9(02)")})})
  private BigDecimal terminatedPassthroughOffsetAmountQq;
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @Schema(description = "Condition for First non-opioid device payment limitation.", example = "2894335.35", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-PAYER-ONLY-VC-QV", value = "PIC 9(09)V9(02)")})})
  private BigDecimal nonOpioidDeviceCapAmountQv;
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @Schema(description = "Second Non-opioid surgical pain relief device payment limitation.", example = "2894225.35", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "L-PAYER-ONLY-VC-QP", value = "PIC 9(09)V9(02)")})})
  private BigDecimal nonOpioidDeviceCapAmountQp;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getApcDeviceOffsetAmountQn() {
    return this.apcDeviceOffsetAmountQn;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getApcDeviceOffsetAmountQo() {
    return this.apcDeviceOffsetAmountQo;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDeviceCreditCapOffsetAmountQu() {
    return this.deviceCreditCapOffsetAmountQu;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTerminatedPassthroughOffsetAmountQq() {
    return this.terminatedPassthroughOffsetAmountQq;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNonOpioidDeviceCapAmountQv() {
    return this.nonOpioidDeviceCapAmountQv;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNonOpioidDeviceCapAmountQp() {
    return this.nonOpioidDeviceCapAmountQp;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApcDeviceOffsetAmountQn(final BigDecimal apcDeviceOffsetAmountQn) {
    this.apcDeviceOffsetAmountQn = apcDeviceOffsetAmountQn;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApcDeviceOffsetAmountQo(final BigDecimal apcDeviceOffsetAmountQo) {
    this.apcDeviceOffsetAmountQo = apcDeviceOffsetAmountQo;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeviceCreditCapOffsetAmountQu(final BigDecimal deviceCreditCapOffsetAmountQu) {
    this.deviceCreditCapOffsetAmountQu = deviceCreditCapOffsetAmountQu;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTerminatedPassthroughOffsetAmountQq(final BigDecimal terminatedPassthroughOffsetAmountQq) {
    this.terminatedPassthroughOffsetAmountQq = terminatedPassthroughOffsetAmountQq;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNonOpioidDeviceCapAmountQv(final BigDecimal nonOpioidDeviceCapAmountQv) {
    this.nonOpioidDeviceCapAmountQv = nonOpioidDeviceCapAmountQv;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNonOpioidDeviceCapAmountQp(final BigDecimal nonOpioidDeviceCapAmountQp) {
    this.nonOpioidDeviceCapAmountQp = nonOpioidDeviceCapAmountQp;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof PayerOnlyValueCodeOffsetData)) return false;
    final PayerOnlyValueCodeOffsetData other = (PayerOnlyValueCodeOffsetData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$apcDeviceOffsetAmountQn = this.getApcDeviceOffsetAmountQn();
    final java.lang.Object other$apcDeviceOffsetAmountQn = other.getApcDeviceOffsetAmountQn();
    if (this$apcDeviceOffsetAmountQn == null ? other$apcDeviceOffsetAmountQn != null : !this$apcDeviceOffsetAmountQn.equals(other$apcDeviceOffsetAmountQn)) return false;
    final java.lang.Object this$apcDeviceOffsetAmountQo = this.getApcDeviceOffsetAmountQo();
    final java.lang.Object other$apcDeviceOffsetAmountQo = other.getApcDeviceOffsetAmountQo();
    if (this$apcDeviceOffsetAmountQo == null ? other$apcDeviceOffsetAmountQo != null : !this$apcDeviceOffsetAmountQo.equals(other$apcDeviceOffsetAmountQo)) return false;
    final java.lang.Object this$deviceCreditCapOffsetAmountQu = this.getDeviceCreditCapOffsetAmountQu();
    final java.lang.Object other$deviceCreditCapOffsetAmountQu = other.getDeviceCreditCapOffsetAmountQu();
    if (this$deviceCreditCapOffsetAmountQu == null ? other$deviceCreditCapOffsetAmountQu != null : !this$deviceCreditCapOffsetAmountQu.equals(other$deviceCreditCapOffsetAmountQu)) return false;
    final java.lang.Object this$terminatedPassthroughOffsetAmountQq = this.getTerminatedPassthroughOffsetAmountQq();
    final java.lang.Object other$terminatedPassthroughOffsetAmountQq = other.getTerminatedPassthroughOffsetAmountQq();
    if (this$terminatedPassthroughOffsetAmountQq == null ? other$terminatedPassthroughOffsetAmountQq != null : !this$terminatedPassthroughOffsetAmountQq.equals(other$terminatedPassthroughOffsetAmountQq)) return false;
    final java.lang.Object this$nonOpioidDeviceCapAmountQv = this.getNonOpioidDeviceCapAmountQv();
    final java.lang.Object other$nonOpioidDeviceCapAmountQv = other.getNonOpioidDeviceCapAmountQv();
    if (this$nonOpioidDeviceCapAmountQv == null ? other$nonOpioidDeviceCapAmountQv != null : !this$nonOpioidDeviceCapAmountQv.equals(other$nonOpioidDeviceCapAmountQv)) return false;
    final java.lang.Object this$nonOpioidDeviceCapAmountQp = this.getNonOpioidDeviceCapAmountQp();
    final java.lang.Object other$nonOpioidDeviceCapAmountQp = other.getNonOpioidDeviceCapAmountQp();
    if (this$nonOpioidDeviceCapAmountQp == null ? other$nonOpioidDeviceCapAmountQp != null : !this$nonOpioidDeviceCapAmountQp.equals(other$nonOpioidDeviceCapAmountQp)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof PayerOnlyValueCodeOffsetData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $apcDeviceOffsetAmountQn = this.getApcDeviceOffsetAmountQn();
    result = result * PRIME + ($apcDeviceOffsetAmountQn == null ? 43 : $apcDeviceOffsetAmountQn.hashCode());
    final java.lang.Object $apcDeviceOffsetAmountQo = this.getApcDeviceOffsetAmountQo();
    result = result * PRIME + ($apcDeviceOffsetAmountQo == null ? 43 : $apcDeviceOffsetAmountQo.hashCode());
    final java.lang.Object $deviceCreditCapOffsetAmountQu = this.getDeviceCreditCapOffsetAmountQu();
    result = result * PRIME + ($deviceCreditCapOffsetAmountQu == null ? 43 : $deviceCreditCapOffsetAmountQu.hashCode());
    final java.lang.Object $terminatedPassthroughOffsetAmountQq = this.getTerminatedPassthroughOffsetAmountQq();
    result = result * PRIME + ($terminatedPassthroughOffsetAmountQq == null ? 43 : $terminatedPassthroughOffsetAmountQq.hashCode());
    final java.lang.Object $nonOpioidDeviceCapAmountQv = this.getNonOpioidDeviceCapAmountQv();
    result = result * PRIME + ($nonOpioidDeviceCapAmountQv == null ? 43 : $nonOpioidDeviceCapAmountQv.hashCode());
    final java.lang.Object $nonOpioidDeviceCapAmountQp = this.getNonOpioidDeviceCapAmountQp();
    result = result * PRIME + ($nonOpioidDeviceCapAmountQp == null ? 43 : $nonOpioidDeviceCapAmountQp.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "PayerOnlyValueCodeOffsetData(apcDeviceOffsetAmountQn=" + this.getApcDeviceOffsetAmountQn() + ", apcDeviceOffsetAmountQo=" + this.getApcDeviceOffsetAmountQo() + ", deviceCreditCapOffsetAmountQu=" + this.getDeviceCreditCapOffsetAmountQu() + ", terminatedPassthroughOffsetAmountQq=" + this.getTerminatedPassthroughOffsetAmountQq() + ", nonOpioidDeviceCapAmountQv=" + this.getNonOpioidDeviceCapAmountQv() + ", nonOpioidDeviceCapAmountQp=" + this.getNonOpioidDeviceCapAmountQp() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PayerOnlyValueCodeOffsetData() {
  }
}
