// Generated by delombok at Mon Dec 08 20:50:48 UTC 2025
package gov.cms.fiss.pricers.opps.api.v2;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

@Schema(description = "The calculated results for a service line.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-LINE-ITEMS", value = "<structure>")})})
public class ServiceLinePaymentData {
  @BigDecimalScale
  @NotNull
  @Schema(description = "The blood deductible amount.", example = "39084.23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-BLOOD-LN-DEDUCT", value = "PIC 9(05)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal bloodDeductible = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The adjusted coinsurance amount.", example = "76834.98", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-ADJ-COIN", value = "PIC 9(09)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal coinsuranceAmount = BigDecimalUtils.ZERO;
  @Max(450)
  @Min(1)
  @NotNull
  @Schema(description = "The line number corresponding to the IOCE service line that was priced.", example = "2")
  private int lineNumber;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The line payment.", example = "108975.47", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-LITEM-PYMT", value = "PIC 9(09)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal payment = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The reduced coinsurance amount.", example = "65434.58", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-RED-COIN", value = "PIC 9(09)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal reducedCoinsurance = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The reimbursement amount.", example = "89734.47", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-LITEM-REIM", value = "PIC 9(09)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal reimbursementAmount = BigDecimalUtils.ZERO;
  @NotNull
  @Valid
  private ReturnCodeData returnCode;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The deductible amount.", example = "983.00", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-TOTAL-LN-DEDUCT", value = "PIC 9(03)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal totalDeductible = BigDecimalUtils.ZERO;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBloodDeductible() {
    return this.bloodDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCoinsuranceAmount() {
    return this.coinsuranceAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLineNumber() {
    return this.lineNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPayment() {
    return this.payment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getReducedCoinsurance() {
    return this.reducedCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getReimbursementAmount() {
    return this.reimbursementAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ReturnCodeData getReturnCode() {
    return this.returnCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalDeductible() {
    return this.totalDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBloodDeductible(final BigDecimal bloodDeductible) {
    this.bloodDeductible = bloodDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoinsuranceAmount(final BigDecimal coinsuranceAmount) {
    this.coinsuranceAmount = coinsuranceAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLineNumber(final int lineNumber) {
    this.lineNumber = lineNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayment(final BigDecimal payment) {
    this.payment = payment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReducedCoinsurance(final BigDecimal reducedCoinsurance) {
    this.reducedCoinsurance = reducedCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReimbursementAmount(final BigDecimal reimbursementAmount) {
    this.reimbursementAmount = reimbursementAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturnCode(final ReturnCodeData returnCode) {
    this.returnCode = returnCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalDeductible(final BigDecimal totalDeductible) {
    this.totalDeductible = totalDeductible;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ServiceLinePaymentData)) return false;
    final ServiceLinePaymentData other = (ServiceLinePaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (this.getLineNumber() != other.getLineNumber()) return false;
    final java.lang.Object this$bloodDeductible = this.getBloodDeductible();
    final java.lang.Object other$bloodDeductible = other.getBloodDeductible();
    if (this$bloodDeductible == null ? other$bloodDeductible != null : !this$bloodDeductible.equals(other$bloodDeductible)) return false;
    final java.lang.Object this$coinsuranceAmount = this.getCoinsuranceAmount();
    final java.lang.Object other$coinsuranceAmount = other.getCoinsuranceAmount();
    if (this$coinsuranceAmount == null ? other$coinsuranceAmount != null : !this$coinsuranceAmount.equals(other$coinsuranceAmount)) return false;
    final java.lang.Object this$payment = this.getPayment();
    final java.lang.Object other$payment = other.getPayment();
    if (this$payment == null ? other$payment != null : !this$payment.equals(other$payment)) return false;
    final java.lang.Object this$reducedCoinsurance = this.getReducedCoinsurance();
    final java.lang.Object other$reducedCoinsurance = other.getReducedCoinsurance();
    if (this$reducedCoinsurance == null ? other$reducedCoinsurance != null : !this$reducedCoinsurance.equals(other$reducedCoinsurance)) return false;
    final java.lang.Object this$reimbursementAmount = this.getReimbursementAmount();
    final java.lang.Object other$reimbursementAmount = other.getReimbursementAmount();
    if (this$reimbursementAmount == null ? other$reimbursementAmount != null : !this$reimbursementAmount.equals(other$reimbursementAmount)) return false;
    final java.lang.Object this$returnCode = this.getReturnCode();
    final java.lang.Object other$returnCode = other.getReturnCode();
    if (this$returnCode == null ? other$returnCode != null : !this$returnCode.equals(other$returnCode)) return false;
    final java.lang.Object this$totalDeductible = this.getTotalDeductible();
    final java.lang.Object other$totalDeductible = other.getTotalDeductible();
    if (this$totalDeductible == null ? other$totalDeductible != null : !this$totalDeductible.equals(other$totalDeductible)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ServiceLinePaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    result = result * PRIME + this.getLineNumber();
    final java.lang.Object $bloodDeductible = this.getBloodDeductible();
    result = result * PRIME + ($bloodDeductible == null ? 43 : $bloodDeductible.hashCode());
    final java.lang.Object $coinsuranceAmount = this.getCoinsuranceAmount();
    result = result * PRIME + ($coinsuranceAmount == null ? 43 : $coinsuranceAmount.hashCode());
    final java.lang.Object $payment = this.getPayment();
    result = result * PRIME + ($payment == null ? 43 : $payment.hashCode());
    final java.lang.Object $reducedCoinsurance = this.getReducedCoinsurance();
    result = result * PRIME + ($reducedCoinsurance == null ? 43 : $reducedCoinsurance.hashCode());
    final java.lang.Object $reimbursementAmount = this.getReimbursementAmount();
    result = result * PRIME + ($reimbursementAmount == null ? 43 : $reimbursementAmount.hashCode());
    final java.lang.Object $returnCode = this.getReturnCode();
    result = result * PRIME + ($returnCode == null ? 43 : $returnCode.hashCode());
    final java.lang.Object $totalDeductible = this.getTotalDeductible();
    result = result * PRIME + ($totalDeductible == null ? 43 : $totalDeductible.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "ServiceLinePaymentData(bloodDeductible=" + this.getBloodDeductible() + ", coinsuranceAmount=" + this.getCoinsuranceAmount() + ", lineNumber=" + this.getLineNumber() + ", payment=" + this.getPayment() + ", reducedCoinsurance=" + this.getReducedCoinsurance() + ", reimbursementAmount=" + this.getReimbursementAmount() + ", returnCode=" + this.getReturnCode() + ", totalDeductible=" + this.getTotalDeductible() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ServiceLinePaymentData() {
  }
}
