// Generated by delombok at Mon Dec 08 20:51:35 UTC 2025
package gov.cms.fiss.pricers.opps;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.ApcRateResource;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.opps.core.Opps2020PricerContext;
import gov.cms.fiss.pricers.opps.core.Opps2021PricerContext;
import gov.cms.fiss.pricers.opps.core.Opps2022PricerContext;
import gov.cms.fiss.pricers.opps.core.Opps2023PricerContext;
import gov.cms.fiss.pricers.opps.core.Opps2024PricerContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerDispatch;
import gov.cms.fiss.pricers.opps.resources.OppsClaimPricingResource;
import gov.cms.fiss.pricers.opps.resources.OppsExtractionUtil;
import io.dropwizard.core.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OppsPricerApplication extends OpenApiPricerApplication<OppsPricerConfiguration> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(OppsPricerApplication.class);

  public static void main(String[] args) throws Exception {
    new OppsPricerApplication().run(args);
  }

  @Override
  protected void configureApplication(OppsPricerConfiguration configuration, Environment environment) {
    final OppsClaimPricingResource v2Resource = new OppsClaimPricingResource(new OppsPricerDispatch(configuration));
    environment.jersey().register(v2Resource);
    environment.jersey().register(new ApcRateResource(configuration, OppsExtractionUtil.APC_EXTRACTOR));
    environment.jersey().register(new CbsaWageIndexResource(configuration, OppsExtractionUtil.CBSA_EXTRACTOR));
  }

  @Override
  protected List<OpenApiCustomizer> getContractCustomizers() {
    final List<OpenApiCustomizer> customizers = new ArrayList<>(super.getContractCustomizers());
    customizers.add((configuration, environment, oas) -> oas.info(new Info().title("OPPS Pricer").version("v1")));
    return customizers;
  }

  @Override
  protected Map<Integer, String> getCalculationVersions() {
    return Map.of(2020, Opps2020PricerContext.CALCULATION_VERSION, 2021, Opps2021PricerContext.CALCULATION_VERSION, 2022, Opps2022PricerContext.CALCULATION_VERSION, 2023, Opps2023PricerContext.CALCULATION_VERSION, 2024, Opps2024PricerContext.CALCULATION_VERSION);
  }

  @Override
  public String getName() {
    return "opps-pricer";
  }

  @Override
  protected List<Package> getResourcePackages() {
    return Collections.singletonList(OppsClaimPricingResource.class.getPackage());
  }
}
