// Generated by delombok at Mon Dec 08 20:51:35 UTC 2025
package gov.cms.fiss.pricers.opps.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.api.v2.OppsPaymentData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.codes.ActionFlag;
import gov.cms.fiss.pricers.opps.core.codes.PackageFlag;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import gov.cms.fiss.pricers.opps.core.codes.PaymentMethodFlag;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.model.APCCalculationData;
import gov.cms.fiss.pricers.opps.core.model.CoinsuranceCapEntry;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.tables.DataTables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * Container for storing state information, constants, annually updated constants and helper
 *
 * <p>methods.
 */
public abstract class OppsPricerContext extends CalculationContext<OppsClaimPricingRequest, OppsClaimPricingResponse> {
  //
  // Constants
  //
  public static final List<String> LINE_DENY_OR_REJECT_FLAG = List.of("0", "3");
  public static final List<String> LINE_REVENUE_CODE = List.of("0390", "0392", "0399");
  public static final List<String> SCH_PROVIDER_TYPE = List.of("16", "17", "21", "22");
  // Add Provider Type = '24' for CY 2023 REH Logic
  public static final List<String> REH_PROVIDER_TYPE_24 = List.of("24");
  // Add Provider Type = '25' for CY 2023 REH Logic
  public static final List<String> REH_PROVIDER_TYPE_25 = List.of("25");
  // PFS = Physician Fee Schedule
  public static final BigDecimal PFS_REDUCTION_COINSURANCE_RATE = new BigDecimal("0.20"); // PFS-COIN-RATE
  public static final BigDecimal PFS_REDUCTION_REIMBURSEMENT_RATE = new BigDecimal("0.80"); // PFS-REIM-RATE
  public static final BigDecimal DISCOUNT_FRACTION = new BigDecimal("0.50000000"); // DISC-FRACTION
  public static final BigDecimal TERMINATION_PROCEDURE_DISCOUNT = new BigDecimal("0.500"); // TERM-PROC-DISC
  public static final BigDecimal OUTLIER_FACTOR = new BigDecimal("1.75"); // H-OUTLIER-FACTOR
  public static final BigDecimal OUTLIER_FACTOR_ALT = new BigDecimal("3.4"); // H-OUTLIER-FACTOR (2nd)
  public static final BigDecimal OUTLIER_PERCENT = new BigDecimal(".5"); // H-OUTLIER-PCT
  public static final BigDecimal CMHC_OUTLIER_PERCENT_CAP = new BigDecimal(".08"); // CMHC-OUTL-CAP-PCT
  private static final Pattern OUTLIER_PROVIDER_CCN = Pattern.compile("..(14|4[679])[0-9][0-9]");
  private static final Pattern RURAL_CBSA = Pattern.compile("0[1-9]|[1-9][0-9]");
  private static final Pattern SIGNIFICANT_PROCEDURE_HCPCS = Pattern.compile("^[1-6][0-9]{4}$");
  //
  // Constants that may need to be updated each year
  //
  private static final BigDecimal DEFAULT_INPATIENT_DEDUCTIBLE_CAP = new BigDecimal(1408);
  private static final BigDecimal DEFAULT_WAGE_INDEX_QUARTILE = new BigDecimal("0.8457");
  private static final BigDecimal DEFAULT_WAGE_INDEX_PERCENT_REDUCTION = new BigDecimal("-0.05");
  private static final BigDecimal DEFAULT_WAGE_INDEX_PERCENT_ADJUSTMENT = new BigDecimal("0.95");
  private static final BigDecimal DEFAULT_PHYSICIAN_FEE_SCHEDULE_REDUCTION = new BigDecimal("0.4");
  private static final BigDecimal DEFAULT_PAYMENT_METHOD_FLAG_A_REDUCTION = new BigDecimal("0.4");
  private static final BigDecimal DEFAULT_CT_SCAN_REDUCTION = new BigDecimal("0.85");
  private static final BigDecimal DEFAULT_X_RAY_FILM_REDUCTION = new BigDecimal("0.8");
  private static final BigDecimal DEFAULT_X_RAY_CRT_REDUCTION = new BigDecimal("0.93");
  private static final BigDecimal DEFAULT_LINE_PAYMENT_OUTLIER_OFFSET = new BigDecimal("5075");
  private static final BigDecimal DEFAULT_APC_QUALITY_REDUCTION = new BigDecimal("0.981");
  private static final BigDecimal DEFAULT_SOLE_COMMUNITY_HOSPITAL_ADJUSTMENT_RATE = new BigDecimal("1.071");
  // New for 2023, REH - 5% add-on constant
  private static final BigDecimal REH_FIVE_PERCENT_ADDON = new BigDecimal("0.05");
  // New for 2023, boolean to indicate REH 5% add-on applied
  private boolean rehExcludeCoinsurance = false;
  // New for 2023, REH Hold variable of 5% amount of payment
  private BigDecimal rehFivePercentAddon;
  // New for 2023, boolean to indicate RuralSCH
  private boolean isRuralSch = false;
  // New for 2023, boolean to indicate provider type ='24'
  // New for 2024, Add Provider Type = '25' for CY2024 : Non-OPPS Provider type
  private boolean isRehProviderType24Or25 = false;
  // New for 2023, REH - 20% constant for coinsurance of REH claim line
  private static final BigDecimal REH_ELIGIBLE_COINSURANCE = new BigDecimal("0.20");
  // New for 2026, 340B Offset Adjustment
  private static final BigDecimal DEFAULT_340B_REMEDY_OFFSET = new BigDecimal("0.9951");
  //
  // Passed in variables
  //
  @JsonIgnore
  private final DataTables dataTables;
  //
  // Calculation (hold) variables
  //
  private final List<CoinsuranceCapEntry> coinsuranceCaps = new ArrayList<>();
  private final SortedMap<String, BigDecimal> compositeSubCharges = new TreeMap<>();
  private List<DeductibleLine> deductibleLines = new ArrayList<>();
  private BigDecimal wageIndex = BigDecimalUtils.ZERO; // H-WINX
  private int beneficiaryBloodPintsUsed; // H-BENE-PINTS-USED
  private BigDecimal beneficiaryDeductible = BigDecimalUtils.ZERO; // H-BENE-DEDUCT
  private BigDecimal claimDeviceCreditAmount = BigDecimalUtils.ZERO; // H-CLAIM-DEVCR-AMT
  private BigDecimal bloodProductCharges = BigDecimalUtils.ZERO; // H-TOT-38X
  private BigDecimal totalBloodCharges = BigDecimalUtils.ZERO; // H-TOT-38X-39X
  private BigDecimal bloodProductPercentage = BigDecimalUtils.ZERO; // H-38X-39X-RATE
  private BigDecimal qnWageAdjustedPassThroughDeviceOffset = BigDecimalUtils.ZERO; // H-QN-WA-PTD-OFFSET
  private BigDecimal qoWageAdjustedPassThroughDeviceOffset = BigDecimalUtils.ZERO; // H-QO-WA-PTD-OFFSET
  private boolean bloodFlag; // BLOOD-FLAG
  private boolean st0Flag; // ST0-FLAG
  private boolean nFlag; // N-FLAG
  private BigDecimal totalCharge = BigDecimalUtils.ZERO; // H-TOT-CHRG
  private BigDecimal totalNCharge = BigDecimalUtils.ZERO; // H-TOT-N-CHRG
  private OutlierPaymentInfo outlierPaymentInfo = new OutlierPaymentInfo();
  private BigDecimal totalSTCharge = BigDecimalUtils.ZERO; // H-TOT-ST-CHRG
  private BigDecimal totalSTPayment = BigDecimalUtils.ZERO; // H-TOT-ST-PYMT
  private BigDecimal totalClaimPayment = BigDecimalUtils.ZERO; // H-TOT-PYMT
  private BigDecimal totalSTVXPayment = BigDecimalUtils.ZERO; // H-TOT-STVX-PYMT
  private BigDecimal inpatientDeductibleLimit = getInpatientDeductibleCap(); // H-IP-LIMIT
  private BigDecimal totalQnPassThroughDeviceCharges = BigDecimalUtils.ZERO; // H-QN-TOT-PTD-CHARGES
  private BigDecimal totalQoPassThroughDeviceCharges = BigDecimalUtils.ZERO; // H-QO-TOT-PTD-CHARGES
  private BigDecimal totalTerminatedProcedureDeviceOffsetPayments = BigDecimalUtils.ZERO; // H-TOT-TPDO-PYMTS
  private BigDecimal totalDeviceCreditPayments = BigDecimalUtils.ZERO; // H-TOT-DEVCR-PYMTS
  private BigDecimal apcPayment = BigDecimalUtils.ZERO; // H-APC-PYMT
  private BigDecimal discountRate = BigDecimalUtils.ZERO; // H-DISC-RATE
  private APCCalculationData apcCalculationData;

  //
  // Constructor
  //
  protected OppsPricerContext(OppsClaimPricingRequest input, OppsClaimPricingResponse output, DataTables dataTables) {
    super(input, output);
    this.dataTables = dataTables;
    initializeContext();
  }

  /**
   * Determines if the given CBSA code is rural.
   *
   * @param cbsa cbsa code
   * @return true if CBSA if between 01 and 99 inclusive
   */
  public static boolean isRuralCbsa(String cbsa) {
    return RURAL_CBSA.matcher(StringUtils.trimToEmpty(cbsa)).matches();
  }

  //
  // Helper methods
  //
  public static boolean isBloodPaymentAdjustment(List<String> paymentAdjustmentFlags) {
    return Stream.of(PaymentAdjustmentFlag.BLOOD_DEDUCTIBLE_5, PaymentAdjustmentFlag.BLOOD_NOT_DEDUCTIBLE_6).anyMatch(paf -> paf.is(paymentAdjustmentFlags));
  }

  /**
   * Determines if line is a section 603 based on the payment method flag.
   */
  public static boolean isSection603(String paymentMethodFlag) {
    return Stream.of(PaymentMethodFlag.SECTION603_NO_REDUCTION_7, PaymentMethodFlag.SECTION603_REDUCTION_8, PaymentMethodFlag.CONTRACTOR_BYPASS_SECTION_603_NO_REDUCTION_X, PaymentMethodFlag.CONTRACTOR_BYPASS_SECTION_603_REDUCTION_Y).anyMatch(pmf -> pmf.is(paymentMethodFlag));
  }

  /**
   * Determines if the given string is considered a Zero value (empty or any combination of spaces
   *
   * <p>and zeros).
   *
   * @param codeString string containing the coded value
   * @return true if codeString is all zeros, empty spaces, and/or empty strings
   */
  public static boolean isZeroValue(String codeString) {
    return StringUtils.isEmpty(RegExUtils.removeAll(codeString, "[0 ]"));
  }

  /**
   * Replaces PKG-BLD-DED-LINE-FLAG.
   */
  public static boolean isComprehensiveBloodDeductible(String statusIndicator, List<String> paymentAdjustmentFlags, boolean comprehensiveApcClaimFlag) {
    // IF C-APC-CLAIM-FLAG = 'Y' AND
    //   OPPS-PYMT-ADJ-FLAG (LN-SUB) = ' 5' AND
    //   OPPS-SRVC-IND (LN-SUB) = ' R'
    //     SET PKG-BLD-DED-LINE TO TRUE
    // END-IF.
    return comprehensiveApcClaimFlag && paymentAdjustmentFlags != null && paymentAdjustmentFlags.contains(PaymentAdjustmentFlag.BLOOD_DEDUCTIBLE_5.getFlag()) && StatusIndicator.R_BLOOD.is(statusIndicator);
  }

  /**
   * Determines if the line has been flagged as an external line item adjustment.
   */
  public static boolean hasExternalAdjustment(String lineActionFlag) {
    return ActionFlag.EXTERNAL_LINE_ITEM_ADJUSTMENT_4.is(lineActionFlag);
  }

  public static boolean isSignificantProcedure(String statusIndicator, String hcpcs) {
    return (StatusIndicator.T_PROCEDURE_REDUCIBLE.is(statusIndicator) || StatusIndicator.S_PROCEDURE_NOT_DISCOUNTED.is(statusIndicator)) && SIGNIFICANT_PROCEDURE_HCPCS.matcher(hcpcs).matches();
  }

  public static boolean isSeparatelyPayable(String statusIndicator) {
    return Stream.of(StatusIndicator.P_PARTIAL_HOSPITALIZATION, StatusIndicator.R_BLOOD, StatusIndicator.S_PROCEDURE_NOT_DISCOUNTED, StatusIndicator.T_PROCEDURE_REDUCIBLE, StatusIndicator.U_BRACHYTHERAPY, StatusIndicator.V_EMERGENCY, StatusIndicator.X_ANCILLARY, StatusIndicator.J1_COMPREHENSIVE_APC_OUTPATIENT, StatusIndicator.J2_COMPREHENSIVE_APC_HOSPITAL).anyMatch(si -> si.is(statusIndicator));
  }

  /**
   * New Technology APCs specific to Status Indicator S based on CSV data.
   *
   * <p>These APCs are excluded from 340B remedy offset.
   */
  public boolean isStatusSNewTechnologyAPC(int numericAPC) {
    // Manual list of Status S New Technology APCs from CSV data to be excluded from 340B
    Set<Integer> statusSNewTechAPCs = Set.of(1491, 1492, 1493, 1494, 1495, 1502, 1503, 1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 1515, 1516, 1517, 1518, 1519, 1520, 1521, 1522, 1523, 1524, 1525, 1526, 1527, 1528, 1529, 1530, 1531, 1532, 1533, 1534, 1535, 1536, 1537, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585);
    return statusSNewTechAPCs.contains(numericAPC);
  }

  /**
   * New Technology APCs specific to Status Indicator T based on CSV data.
   *
   * <p>These APCs are excluded from 340B remedy offset.
   */
  public boolean isStatusTNewTechnologyAPC(int numericAPC) {
    // Manual list of Status T New Technology APCs from CSV data to be excluded from 340B
    Set<Integer> statusTNewTechAPCs = Set.of(1496, 1497, 1498, 1499, 1500, 1539, 1540, 1541, 1542, 1543, 1544, 1545, 1546, 1547, 1548, 1549, 1550, 1551, 1552, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560, 1561, 1562, 1563, 1564, 1565, 1566, 1567, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1589, 1590, 1591, 1592, 1593, 1594, 1595, 1596, 1597, 1598, 1599);
    return statusTNewTechAPCs.contains(numericAPC);
  }

  protected void initializeContext() {
    // Initializes service line output records to match service line input records.
    getPaymentData().setServiceLinePayments(new ArrayList<>());
    getOutput().setReturnCodeData(ReturnCode.PROCESSED_1.toReturnCodeData());
    for (final IoceServiceLineData lineInput : getClaimData().getIoceServiceLines()) {
      final ServiceLinePaymentData lineOutput = new ServiceLinePaymentData();
      lineOutput.setLineNumber(lineInput.getLineNumber());
      lineOutput.setReturnCode(ReturnCode.NOT_PROCESSED_0.toReturnCodeData());
      getPaymentData().getServiceLinePayments().add(lineOutput);
    }
  }

  /**
   * Adds an entry to the coinsurance cap roll-up table.
   */
  public void addCoinsuranceCap(CoinsuranceCapEntry coinsuranceCapEntry) {
    coinsuranceCaps.add(coinsuranceCapEntry);
  }

  /**
   * Retrieves the composite sub-charge for the given composite adjustment flag.
   */
  public BigDecimal getCompositeSubCharge(String compositeAdjustmentFlag) {
    return compositeSubCharges.get(compositeAdjustmentFlag);
  }

  /**
   * DETERMINE WHETHER A NEW COMPOSITE APC TABLE RECORD SHOULD BE ADDED OR IF AN EXISTING RECORD
   *
   * <p>NEEDS TO BE UPDATED.
   *
   * <p>(Extracted from 19171-SEARCH-CAF)
   */
  public void addCompositeSubCharge(String compositeAdjustmentFlag, BigDecimal submittedCharge) {
    final BigDecimal compositeTotalSubCharge = compositeSubCharges.get(compositeAdjustmentFlag);
    if (compositeTotalSubCharge == null) {
      compositeSubCharges.put(compositeAdjustmentFlag, submittedCharge);
    } else {
      compositeSubCharges.replace(compositeAdjustmentFlag, compositeTotalSubCharge.add(submittedCharge));
    }
  }

  /**
   * Returns the ServiceLineOutputRecord that has the given line number.
   */
  @SuppressWarnings("java:S2637")
  public ServiceLinePaymentData getServiceLinePaymentByLineNumber(int number) {
    return 
    // Suppress java:S2637 - False alarm. orElse does not mark its parameter as @NotNull.
    getPaymentData().getServiceLinePayments().stream().filter(e -> e.getLineNumber() == number).findFirst().orElse(null);
  }

  /**
   * FLAG CLAIM WHEN AT LEAST 1 LINE HAS A COMPREHENSIVE APC.
   *
   * <p>(19125-INIT) - Replaces C-APC-CLAIM-FLAG
   */
  public boolean getComprehensiveApcClaimStatus() {
    return getClaimData().getIoceServiceLines().stream().anyMatch(line -> isComprehensiveApc(line.getStatusIndicator()));
  }

  private boolean isComprehensiveApc(String statusIndicator) {
    return Stream.of(StatusIndicator.J1_COMPREHENSIVE_APC_OUTPATIENT, StatusIndicator.J2_COMPREHENSIVE_APC_HOSPITAL).anyMatch(si -> si.is(statusIndicator));
  }

  /**
   * Update claim return code and determine if subsequent rules should processed.
   */
  public void applyClaimReturnCode(ReturnCode returnCode) {
    getOutput().setReturnCodeData(returnCode.toReturnCodeData());
    if (returnCode.getCode() >= 50) {
      setCalculationCompleted();
    }
  }

  /**
   * Determines if the line is a blood deductible line.
   */
  public boolean isBloodDeductibleHcpcsLine(String statusIndicator, String hcpcs, List<String> paymentAdjustmentFlags) {
    return StatusIndicator.R_BLOOD.is(statusIndicator) && dataTables.isBloodHcpcsDeductible(hcpcs) && isBloodPaymentAdjustment(paymentAdjustmentFlags);
  }

  /**
   * Checks if the provider CCN on the claim is in the 340B list.
   *
   * @return true if the provider CCN matches a provider CCN in the 340B list, false otherwise
   */
  public boolean isProviderCcn340B() {
    final String providerCcn = getProviderData().getProviderCcn();
    return dataTables.isProviderCcn340B(providerCcn);
  }

  /**
   * Determines if line is not eligible for an outlier payment.
   *
   * <pre>
   *
   * SERVICE LINES NOT ELIGIBLE FOR AN OUTLIER PAYMENT:
   *
   * - DEVICES, PACKAGED, PACKAGED AS PART OF DRUG ADMIN, AND SECTION 603 SERVICES
   *
   *
   *
   * BLOOD LINES ELIGIBLE FOR THE BLOOD DEDUCTIBLE AND ON A CLAIM WITH A COMPREHENSIVE APC NOT
   *
   * ELIGIBLE FOR OUTLIER
   *
   * </pre>
   *
   * <p>(Extracted from 19600-ADJ-CHRG-OUTL)
   */
  public boolean notEligibleForOutlierPayment(String statusIndicator, String packageFlag, String paymentMethodFlag, List<String> paymentAdjustmentFlags) {
    return Stream.of(StatusIndicator.H_PASS_THROUGH_DEVICE, StatusIndicator.N_PACKAGED_INTO_APC).anyMatch(si -> si.is(statusIndicator)) || PackageFlag.DRUG_ADMINISTRATION_4.is(packageFlag) || isSection603(paymentMethodFlag) || isComprehensiveBloodDeductible(statusIndicator, paymentAdjustmentFlags, getComprehensiveApcClaimStatus());
  }

  /**
   * Returns true if the claim is from a CMHC provider.
   */
  public boolean isCommunityMentalHealthCenter() {
    return OppsPricerContext.OUTLIER_PROVIDER_CCN.matcher(getProviderData().getProviderCcn()).matches();
  }

  /**
   * Returns true if the claim is excluded from the REH %5 add-on.
   *
   * <p><br>
   * NOTE: This function is primarily for keeping track of policy. Claims with the status indicators
   *
   * <p>A, F, and L will never reach this point in calculation. Claims with status indicators G and
   * K
   *
   * <p>are not priced by the OPPS Pricer.
   */
  public boolean isREHStatusIndicatorExclusion(String statusIndicator) {
    return Stream.of(StatusIndicator.A_NOT_PAID_OPPS, StatusIndicator.F_CORNEAL_TISSUE, StatusIndicator.G_DRUG_PASS_THROUGH, StatusIndicator.K_NON_PASS_THROUGH_DRUG, StatusIndicator.L_FLU_PPV_VACCINES).anyMatch(si -> si.is(statusIndicator));
  }

  public OutpatientProviderData getProviderData() {
    return getInput().getProviderData();
  }

  //
  // Getters for annual constants that may change each year
  //
  @JsonIgnore
  public OppsClaimData getClaimData() {
    return getInput().getClaimData();
  }

  @JsonIgnore
  public OppsPaymentData getPaymentData() {
    return getOutput().getPaymentData();
  }

  public abstract String getCalculationVersion();

  public BigDecimal getInpatientDeductibleCap() {
    return DEFAULT_INPATIENT_DEDUCTIBLE_CAP;
  }

  public BigDecimal getWageIndexQuartile() {
    return DEFAULT_WAGE_INDEX_QUARTILE;
  }

  public BigDecimal getWageIndexPercentReduction() {
    return DEFAULT_WAGE_INDEX_PERCENT_REDUCTION;
  }

  public BigDecimal getWageIndexPercentAdjustment() {
    return DEFAULT_WAGE_INDEX_PERCENT_ADJUSTMENT;
  }

  public BigDecimal getPhysicianFeeScheduleReduction() {
    return DEFAULT_PHYSICIAN_FEE_SCHEDULE_REDUCTION;
  }

  public BigDecimal getPaymentMethodFlagAReduction() {
    return DEFAULT_PAYMENT_METHOD_FLAG_A_REDUCTION;
  }

  public BigDecimal getCTScanReduction() {
    return DEFAULT_CT_SCAN_REDUCTION;
  }

  public BigDecimal getXRayFilmReduction() {
    return DEFAULT_X_RAY_FILM_REDUCTION;
  }

  public BigDecimal getXRayCRTReduction() {
    return DEFAULT_X_RAY_CRT_REDUCTION;
  }

  public BigDecimal getLinePaymentOutlierOffset() {
    return DEFAULT_LINE_PAYMENT_OUTLIER_OFFSET;
  }

  public BigDecimal getApcQualityReduction() {
    return DEFAULT_APC_QUALITY_REDUCTION;
  }

  public BigDecimal getSoleCommunityHospitalAdjustmentRate() {
    return DEFAULT_SOLE_COMMUNITY_HOSPITAL_ADJUSTMENT_RATE;
  }

  public BigDecimal getREHApplyFivePercentAddOn() {
    return REH_FIVE_PERCENT_ADDON;
  }

  public BigDecimal getRehEligibleCoinsurance() {
    return REH_ELIGIBLE_COINSURANCE;
  }

  public BigDecimal get340BRemedyOffset() {
    return DEFAULT_340B_REMEDY_OFFSET;
  }

  /**
   * Added for 2022- to apply PAF '25' Coinsurance Cap, ability to Override value each year. All
   *
   * <p>prior years will return 100%, constant will be updated for Years 2022 and forward.
   */
  public BigDecimal getColonialProcedureCap() {
    return BigDecimal.ONE;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isRehExcludeCoinsurance() {
    return this.rehExcludeCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRehExcludeCoinsurance(final boolean rehExcludeCoinsurance) {
    this.rehExcludeCoinsurance = rehExcludeCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRehFivePercentAddon() {
    return this.rehFivePercentAddon;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRehFivePercentAddon(final BigDecimal rehFivePercentAddon) {
    this.rehFivePercentAddon = rehFivePercentAddon;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isRuralSch() {
    return this.isRuralSch;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRuralSch(final boolean isRuralSch) {
    this.isRuralSch = isRuralSch;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isRehProviderType24Or25() {
    return this.isRehProviderType24Or25;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRehProviderType24Or25(final boolean isRehProviderType24Or25) {
    this.isRehProviderType24Or25 = isRehProviderType24Or25;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DataTables getDataTables() {
    return this.dataTables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<CoinsuranceCapEntry> getCoinsuranceCaps() {
    return this.coinsuranceCaps;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<DeductibleLine> getDeductibleLines() {
    return this.deductibleLines;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeductibleLines(final List<DeductibleLine> deductibleLines) {
    this.deductibleLines = deductibleLines;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWageIndex() {
    return this.wageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWageIndex(final BigDecimal wageIndex) {
    this.wageIndex = wageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getBeneficiaryBloodPintsUsed() {
    return this.beneficiaryBloodPintsUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBeneficiaryBloodPintsUsed(final int beneficiaryBloodPintsUsed) {
    this.beneficiaryBloodPintsUsed = beneficiaryBloodPintsUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBeneficiaryDeductible() {
    return this.beneficiaryDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBeneficiaryDeductible(final BigDecimal beneficiaryDeductible) {
    this.beneficiaryDeductible = beneficiaryDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getClaimDeviceCreditAmount() {
    return this.claimDeviceCreditAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClaimDeviceCreditAmount(final BigDecimal claimDeviceCreditAmount) {
    this.claimDeviceCreditAmount = claimDeviceCreditAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBloodProductCharges() {
    return this.bloodProductCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBloodProductCharges(final BigDecimal bloodProductCharges) {
    this.bloodProductCharges = bloodProductCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalBloodCharges() {
    return this.totalBloodCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalBloodCharges(final BigDecimal totalBloodCharges) {
    this.totalBloodCharges = totalBloodCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBloodProductPercentage() {
    return this.bloodProductPercentage;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBloodProductPercentage(final BigDecimal bloodProductPercentage) {
    this.bloodProductPercentage = bloodProductPercentage;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getQnWageAdjustedPassThroughDeviceOffset() {
    return this.qnWageAdjustedPassThroughDeviceOffset;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQnWageAdjustedPassThroughDeviceOffset(final BigDecimal qnWageAdjustedPassThroughDeviceOffset) {
    this.qnWageAdjustedPassThroughDeviceOffset = qnWageAdjustedPassThroughDeviceOffset;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getQoWageAdjustedPassThroughDeviceOffset() {
    return this.qoWageAdjustedPassThroughDeviceOffset;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQoWageAdjustedPassThroughDeviceOffset(final BigDecimal qoWageAdjustedPassThroughDeviceOffset) {
    this.qoWageAdjustedPassThroughDeviceOffset = qoWageAdjustedPassThroughDeviceOffset;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isBloodFlag() {
    return this.bloodFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBloodFlag(final boolean bloodFlag) {
    this.bloodFlag = bloodFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isSt0Flag() {
    return this.st0Flag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSt0Flag(final boolean st0Flag) {
    this.st0Flag = st0Flag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isNFlag() {
    return this.nFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNFlag(final boolean nFlag) {
    this.nFlag = nFlag;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalCharge() {
    return this.totalCharge;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalCharge(final BigDecimal totalCharge) {
    this.totalCharge = totalCharge;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalNCharge() {
    return this.totalNCharge;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalNCharge(final BigDecimal totalNCharge) {
    this.totalNCharge = totalNCharge;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OutlierPaymentInfo getOutlierPaymentInfo() {
    return this.outlierPaymentInfo;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPaymentInfo(final OutlierPaymentInfo outlierPaymentInfo) {
    this.outlierPaymentInfo = outlierPaymentInfo;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalSTCharge() {
    return this.totalSTCharge;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalSTCharge(final BigDecimal totalSTCharge) {
    this.totalSTCharge = totalSTCharge;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalSTPayment() {
    return this.totalSTPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalSTPayment(final BigDecimal totalSTPayment) {
    this.totalSTPayment = totalSTPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalClaimPayment() {
    return this.totalClaimPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalClaimPayment(final BigDecimal totalClaimPayment) {
    this.totalClaimPayment = totalClaimPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalSTVXPayment() {
    return this.totalSTVXPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalSTVXPayment(final BigDecimal totalSTVXPayment) {
    this.totalSTVXPayment = totalSTVXPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getInpatientDeductibleLimit() {
    return this.inpatientDeductibleLimit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInpatientDeductibleLimit(final BigDecimal inpatientDeductibleLimit) {
    this.inpatientDeductibleLimit = inpatientDeductibleLimit;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalQnPassThroughDeviceCharges() {
    return this.totalQnPassThroughDeviceCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalQnPassThroughDeviceCharges(final BigDecimal totalQnPassThroughDeviceCharges) {
    this.totalQnPassThroughDeviceCharges = totalQnPassThroughDeviceCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalQoPassThroughDeviceCharges() {
    return this.totalQoPassThroughDeviceCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalQoPassThroughDeviceCharges(final BigDecimal totalQoPassThroughDeviceCharges) {
    this.totalQoPassThroughDeviceCharges = totalQoPassThroughDeviceCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalTerminatedProcedureDeviceOffsetPayments() {
    return this.totalTerminatedProcedureDeviceOffsetPayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalTerminatedProcedureDeviceOffsetPayments(final BigDecimal totalTerminatedProcedureDeviceOffsetPayments) {
    this.totalTerminatedProcedureDeviceOffsetPayments = totalTerminatedProcedureDeviceOffsetPayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalDeviceCreditPayments() {
    return this.totalDeviceCreditPayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalDeviceCreditPayments(final BigDecimal totalDeviceCreditPayments) {
    this.totalDeviceCreditPayments = totalDeviceCreditPayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getApcPayment() {
    return this.apcPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApcPayment(final BigDecimal apcPayment) {
    this.apcPayment = apcPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDiscountRate() {
    return this.discountRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiscountRate(final BigDecimal discountRate) {
    this.discountRate = discountRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public APCCalculationData getApcCalculationData() {
    return this.apcCalculationData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApcCalculationData(final APCCalculationData apcCalculationData) {
    this.apcCalculationData = apcCalculationData;
  }
}
