// Generated by delombok at Mon Dec 08 20:51:35 UTC 2025
package gov.cms.fiss.pricers.opps.core.codes;

import java.util.List;
import org.apache.commons.lang3.StringUtils;

@SuppressWarnings("unused")
public enum PaymentAdjustmentFlag {
  /**
   * No payment adjustment.
   */
  NO_ADJUSTMENT_0("0"), /**
   * Paid standard amount for pass-through drug or biological.
   */
  STANDARD_1("1"), /**
   * Payment based on charge adjusted to cost.
   */
  COST_ADJUSTED_CHARGE_2("2"), /**
   * Additional payment for new drug or new biological applies to APC.
   */
  APPLIED_TO_APC_3("3"), /**
   * Deductible not applicable (specific list of HCPCS codes) or condition code "MA" is present on
   * the claim.
   */
  DEDUCTIBLE_NOT_APPLICABLE_4("4"), /**
   * // Blood/blood product used in blood deductible calculation.
   */
  BLOOD_DEDUCTIBLE_5("5"), /**
   * Blood processing/storage not subject to blood deductible.
   */
  BLOOD_NOT_DEDUCTIBLE_6("6"), /**
   * Item provided without cost to provider.
   */
  NO_COST_7("7"), /**
   * Item provided with partial credit to provider.
   */
  PARTIAL_COST_8("8"), /**
   * Deductible/co-insurance not applicable.
   */
  DEDUCTIBLE_AND_COINSURANCE_NOT_APPLICABLE_9("9"), /**
   * Co-insurance not applicable.
   */
  COINSURANCE_NOT_APPLICABLE_10("10"), /**
   * Multiple service units reduced to one by IOCE processing; payment based on single payment rate.
   */
  MULTIPLE_SERVICE_UNITS_11("11"), /**
   * Offset for first device pass-through.
   */
  DEVICE_PASS_THROUGH_12("12"), /**
   * Offset for second device pass-through.
   */
  DEVICE_PASS_THROUGH_13("13"), /**
   * PAMA Section 218 reduction on CT scan.
   */
  CT_SCAN_14("14"), /**
   * Placeholder reserved for future use.
   */
  PLACEHOLDER_15("15"), /**
   * Terminated procedure with pass-through device.
   */
  TERMINATED_PROCEDURE_PASS_THROUGH_DEVICE_16("16"), /**
   * Condition for device credit present.
   */
  DEVICE_CREDIT_17("17"), /**
   * Offset for first pass-through drug or biological.
   */
  DRUG_BIOLOGICAL_FIRST_18("18"), /**
   * Offset for second pass-through drug or biological.
   */
  DRUG_BIOLOGICAL_SECOND_19("19"), /**
   * Offset for third pass-through drug or biological.
   */
  DRUG_BIOLOGICAL_THIRD_20("20"), /**
   * CAA Section 502(b) reduction on film X-ray.
   */
  X_RAY_21("21"), /**
   * CAA Section 502(b) reduction on computed radiography technology.
   */
  COMPUTED_RADIOLOGY_22("22"), /**
   * Co-insurance deductible n/a, as well as subject to a reduction due to film x-ray.
   */
  X_RAY_NO_COINSURANCE_23("23"), /**
   * Co-insurance deductible n/a, as well as subject to a reduction due to computed radiography
   * technology.
   */
  COMPUTED_RADIOLOGY_NO_COINSURANCE_24("24"), /**
   * Deductible not applicable and coinsurance reduced with modifier PT reported on applicable
   * procedure.
   */
  COLONIAL_PROCEDURE_25("25"), FIRST_LINE_CAP_NONOPIOID_H1_26("26"), /**
   * Payment limitation for first H1 device
   */
  SECOND_LINE_CAP_NONOPIOID_H1_27("27");
  /**
   * Payment limitation for second H1 device
   */
  private final String flag;

  PaymentAdjustmentFlag(String flag) {
    this.flag = flag;
  }

  public boolean is(List<String> paymentAdjustmentFlags) {
    return paymentAdjustmentFlags != null && paymentAdjustmentFlags.stream().anyMatch(this::is);
  }

  public boolean is(String paymentAdjustmentFlag) {
    return StringUtils.equals(flag, paymentAdjustmentFlag);
  }

  /**
   * Payment limitation for second H1 device
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFlag() {
    return this.flag;
  }
}
