// Generated by delombok at Mon Dec 08 20:51:35 UTC 2025
package gov.cms.fiss.pricers.opps.core.codes;

import org.apache.commons.lang3.StringUtils;

public enum PaymentIndicator {
  /**
   * Paid standard hospital OPPS amount.
   */
  PAID_STANDARD_HOSPITAL_OPPS_AMOUNT_1("1"), /**
   * Services not paid by OPPS Pricer; paid under fee schedule or other payment system.
   */
  SERVICES_NOT_PAID_BY_OPPS_PRICER_2("2"), /**
   * Not paid or not paid under OPPS.
   */
  NOT_PAID_3("3"), /**
   * Paid at reasonable cost.
   */
  PAID_AT_REASONABLE_COST_4("4"), /**
   * Paid standard amount for pass-through drug or biological.
   */
  PAID_STANDARD_AMOUNT_FOR_PASS_THROUGH_DRUG_OR_BIOLOGICAL_5("5"), /**
   * Payment based on charge adjusted to cost.
   */
  PAYMENT_BASED_ON_CHARGE_ADJUSTED_TO_COST_6("6"), /**
   * Additional payment for new drug or new biological.
   */
  ADDITIONAL_PAYMENT_FOR_NEW_DRUG_OR_BIOLOGICAL_7("7"), /**
   * Paid partial hospitalization per diem.
   */
  PAID_PARTIAL_HOSPITALIZATION_PER_DIEM_8("8"), /**
   * No additional payment; payment included in line items with APCs.
   */
  NO_ADDITIONAL_PAYMENT_9("9"), /**
   * Paid FQHC encounter payment.
   */
  PAID_FQHC_ENCOUNTER_PAYMENT_10("10"), /**
   * Not paid or not included under FQHC encounter payment.
   */
  NOT_PAID_OR_NOT_INCLUDED_UNDER_FQHC_ENCOUNTER_PAYMENT_11("11"), /**
   * No additional payment, included in payment for FQHC encounter.
   */
  NO_ADDITIONAL_PAYMENT_12("12"), /**
   * Paid FQHC encounter payment for New patient or IPPE/AWV.
   */
  PAID_FQHC_ENCOUNTER_PAYMENT_FOR_NEW_PATIENT_OR_IPPE_AMW_13("13"), /**
   * Grandfathered tribal FQHC encounter payment.
   */
  GRANDFATHERED_TRIBAL_FQHC_ENCOUNTER_PAYMENT_14("14");
  private final String indicator;

  PaymentIndicator(String indicator) {
    this.indicator = indicator;
  }

  public boolean is(String paymentIndicator) {
    return StringUtils.equals(indicator, paymentIndicator);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getIndicator() {
    return this.indicator;
  }
}
