// Generated by delombok at Mon Dec 08 20:51:35 UTC 2025
package gov.cms.fiss.pricers.opps.core.codes;

import org.apache.commons.lang3.StringUtils;

@SuppressWarnings("unused")
public enum StatusIndicator {
  /**
   * Services not paid under OPPS; paid under fee schedule or other payment system.
   */
  A_NOT_PAID_OPPS("A"), /**
   * Non-allowed item or service for OPPS.
   */
  B_NOT_ALLOWED_OPPS("B"), /**
   * Inpatient procedure.
   */
  C_INPATIENT_PROCEDURE("C"), /**
   * Non-allowed item or service (discontinued 01/01/2017).
   */
  E_DEPRECATED_NOT_ALLOWED("E"), /**
   * Non-allowed item or service.
   */
  E1_NOT_ALLOWED("E1"), /**
   * Items and services for which pricing information and claims data are not available.
   */
  E2_NO_DATA("E2"), /**
   * Corneal tissue acquisition; certain CRNA services and hepatitis B vaccines.
   */
  F_CORNEAL_TISSUE("F"), /**
   * Drug/Biological pass-through.
   */
  G_DRUG_PASS_THROUGH("G"), /**
   * Pass-through device categories.
   */
  H_PASS_THROUGH_DEVICE("H"), /**
   * New drug or new biological pass-through (discontinued 04/01/2002 and replaced by status
   * indicator G for all drugs/biologicals).
   */
  H1_NON_OPIOID_MEDICAL_DEVICE("H1"), /**
   * Non-opioid Medical Devices for Post-Surgical Pain Relief.
   */
  J_DEPRECATED_DRUG_PASS_THROUGH("J"), /**
   * Outpatient department services paid through a comprehensive APC.
   */
  J1_COMPREHENSIVE_APC_OUTPATIENT("J1"), /**
   * Hospital Part B services that may be paid through a comprehensive APC.
   */
  J2_COMPREHENSIVE_APC_HOSPITAL("J2"), /**
   * Non pass-through drugs and non-implantable biologicals, including therapeutic
   * radiopharmaceuticals.
   */
  K_NON_PASS_THROUGH_DRUG("K"), /**
   * Flu/PPV vaccines.
   */
  K1_NON_OPIOID_DRUG("K1"), /**
   * Non-opioid Drugs and Biologicals for Post-Surgical Pain Relief.
   */
  L_FLU_PPV_VACCINES("L"), /**
   * Service not billable to the FI/MAC.
   */
  M_NOT_BILLABLE_TO_MAC("M"), /**
   * Items and Services packaged into APC rates.
   */
  N_PACKAGED_INTO_APC("N"), /**
   * Partial hospitalization service.
   */
  P_PARTIAL_HOSPITALIZATION("P"), /**
   * Packaged services subject to separate payment based on payment criteria (discontinued
   * 01/01/2009 and replaced by status indicators Q1, Q2, Q3, Q4).
   */
  Q_DEPRECATED_SEPARATELY_PAYABLE("Q"), /**
   * STVX-packaged codes.
   */
  Q1_STV_PACKAGED_CODES("Q1"), /**
   * T-packaged codes.
   */
  Q2_T_PACKAGED_CODES("Q2"), /**
   * Codes that may be paid through a composite APC.
   */
  Q3_COMPOSITELY_PAYABLE("Q3"), /**
   * Conditionally packaged laboratory services.
   */
  Q4_CONDITIONALLY_PACKAGED_LAB("Q4"), /**
   * Blood and blood products.
   */
  R_BLOOD("R"), /**
   * Significant procedure not subject to multiple procedure discounting.
   */
  S_PROCEDURE_NOT_DISCOUNTED("S"), /**
   * Significant procedure subject to multiple procedure discounting.
   */
  S1_SKIN_SUBSTITUTE("S1"), /**
   * Skin substitute product paid separately.
   */
  T_PROCEDURE_REDUCIBLE("T"), /**
   * Brachytherapy sources.
   */
  U_BRACHYTHERAPY("U"), /**
   * Clinic or emergency department visit.
   */
  V_EMERGENCY("V"), /**
   * Invalid HCPCS or Invalid revenue code with blank HCPCS.
   */
  W_INVALID("W"), /**
   * Ancillary service.
   */
  X_ANCILLARY("X"), /**
   * Non-implantable DME.
   */
  Y_NON_IMPLANTABLE_DME("Y"), /**
   * Valid revenue code with blank HCPCS and no other SI assigned.
   */
  Z_VALID_WITH_BLANK_HCPCS("Z");
  private final String indicator;

  StatusIndicator(String indicator) {
    this.indicator = indicator;
  }

  public boolean is(String statusIndicator) {
    return StringUtils.equals(this.indicator, statusIndicator);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getIndicator() {
    return this.indicator;
  }
}
