package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.calculate_status_indicator_payments;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;

public class SkinSubstitutes2026 extends AbstractStatusIndicatorPayments2026 {

  /** CALCULATE PAYMENT FOR SI = S1 LINES (SKIN SUBSTITUTES). */
  @Override
  public boolean shouldExecute(DeductibleLineContext context) {
    return isSkinSubstitute(context.getStatusIndicator());
  }

  /**
   * Calculates payment for S1 (Skin Substitute) lines.
   *
   * <p>S1 lines are NOT wage-adjusted but follow similar logic to R and U lines.
   */
  @Override
  public void calculate(DeductibleLineContext calculationContext) {
    final LineCalculation lineCalculation = calculationContext.getLineCalculation();
    final OppsPricerContext pricerContext = calculationContext.getPricerContext();
    final OutpatientProviderData providerData = pricerContext.getProviderData();
    final String billType = pricerContext.getClaimData().getTypeOfBill();

    // Use the non-wage-adjusted calculation path for S1 lines
    calculateNonWageAdjustedPaymentAndSchAdj(
        pricerContext, providerData, lineCalculation, billType);

    pricerContext.setBeneficiaryDeductible(
        calculateBeneficiaryDeductible(lineCalculation, pricerContext.getBeneficiaryDeductible()));
  }
}
