// Generated by delombok at Mon Dec 08 20:51:35 UTC 2025
package gov.cms.fiss.pricers.opps.core.tables;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonFormat.Shape;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.tables.ApcRateHistoryEntry.Fields;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
@JsonDeserialize(builder = ApcRateHistoryEntry.ApcRateHistoryEntryBuilder.class)
@JsonPropertyOrder({Fields.APC, Fields.STATUS_INDICATOR, Fields.EFFECTIVE_DATE, Fields.PAYMENT_RATE, Fields.NATIONAL_COINSURANCE, Fields.MINIMUM_COINSURANCE})
public class ApcRateHistoryEntry {

  @JsonPOJOBuilder(withPrefix = "")
  public static class ApcRateHistoryEntryBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String apc;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String statusIndicator;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private LocalDate effectiveDate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal paymentRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal nationalCoinsurance;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal minimumCoinsurance;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer rank;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    ApcRateHistoryEntryBuilder() {
    }

    /**
     * Corresponds to {@code WAA-APC PIC 9(5)} from the COBOL source.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApcRateHistoryEntry.ApcRateHistoryEntryBuilder apc(final String apc) {
      this.apc = apc;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApcRateHistoryEntry.ApcRateHistoryEntryBuilder statusIndicator(final String statusIndicator) {
      this.statusIndicator = statusIndicator;
      return this;
    }

    /**
     * Corresponds to {@code WAD-DATE PIC X(8)} from the COBOL source.
     * @return {@code this}.
     */
    @JsonFormat(shape = Shape.STRING, pattern = "yyyyMMdd")
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApcRateHistoryEntry.ApcRateHistoryEntryBuilder effectiveDate(final LocalDate effectiveDate) {
      this.effectiveDate = effectiveDate;
      return this;
    }

    /**
     * Corresponds to {@code WAR-RATE PIC 9(6)V99} from the COBOL source.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApcRateHistoryEntry.ApcRateHistoryEntryBuilder paymentRate(final BigDecimal paymentRate) {
      this.paymentRate = paymentRate;
      return this;
    }

    /**
     * Corresponds to {@code WAR-COIN PIC 9(5)V99} from the COBOL source.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApcRateHistoryEntry.ApcRateHistoryEntryBuilder nationalCoinsurance(final BigDecimal nationalCoinsurance) {
      this.nationalCoinsurance = nationalCoinsurance;
      return this;
    }

    /**
     * Corresponds to {@code WAR-MINC PIC 9(5)V99} from the COBOL source.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApcRateHistoryEntry.ApcRateHistoryEntryBuilder minimumCoinsurance(final BigDecimal minimumCoinsurance) {
      this.minimumCoinsurance = minimumCoinsurance;
      return this;
    }

    /**
     * Corresponds to {@code WAR-RANK PIC 9(5)} from the COBOL source.
     * @return {@code this}.
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApcRateHistoryEntry.ApcRateHistoryEntryBuilder rank(final Integer rank) {
      this.rank = rank;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApcRateHistoryEntry build() {
      return new ApcRateHistoryEntry(this.apc, this.statusIndicator, this.effectiveDate, this.paymentRate, this.nationalCoinsurance, this.minimumCoinsurance, this.rank);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "ApcRateHistoryEntry.ApcRateHistoryEntryBuilder(apc=" + this.apc + ", statusIndicator=" + this.statusIndicator + ", effectiveDate=" + this.effectiveDate + ", paymentRate=" + this.paymentRate + ", nationalCoinsurance=" + this.nationalCoinsurance + ", minimumCoinsurance=" + this.minimumCoinsurance + ", rank=" + this.rank + ")";
    }
  }

  private static final BigDecimal PERCENT_100 = new BigDecimal("1.0").setScale(9, RoundingMode.UNNECESSARY);
  private static final BigDecimal PERCENT_80 = new BigDecimal(".8").setScale(9, RoundingMode.UNNECESSARY);
  private static final BigDecimal PERCENT_75 = new BigDecimal(".75").setScale(9, RoundingMode.UNNECESSARY);
  /**
   * Corresponds to {@code WAA-APC PIC 9(5)} from the COBOL source.
   */
  @Pattern(regexp = "0\\d{4}")
  private final String apc;
  @Pattern(regexp = "\\w\\w?")
  private final String statusIndicator;
  /**
   * Corresponds to {@code WAD-DATE PIC X(8)} from the COBOL source.
   */
  @JsonFormat(shape = Shape.STRING, pattern = "yyyyMMdd")
  private final LocalDate effectiveDate;
  /**
   * Corresponds to {@code WAR-RATE PIC 9(6)V99} from the COBOL source.
   */
  @Digits(integer = 6, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("999999.99")
  @BigDecimalScale
  private final BigDecimal paymentRate;
  /**
   * Corresponds to {@code WAR-COIN PIC 9(5)V99} from the COBOL source.
   */
  @Digits(integer = 5, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("99999.99")
  @BigDecimalScale
  private final BigDecimal nationalCoinsurance;
  /**
   * Corresponds to {@code WAR-MINC PIC 9(5)V99} from the COBOL source.
   */
  @Digits(integer = 5, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("99999.99")
  @BigDecimalScale
  private final BigDecimal minimumCoinsurance;
  /**
   * Corresponds to {@code WAR-RANK PIC 9(5)} from the COBOL source.
   */
  @JsonIgnore
  private final Integer rank;

  /**
   * Corresponds to {@code WAR-PPCT PIC 9V9(6)} from the COBOL source.
   */
  @JsonIgnore
  public final BigDecimal getReimbursementPercent() {
    return calculateReimbursementRate().setScale(6, RoundingMode.HALF_UP);
  }

  /**
   * Returns the derived reimbursement percent with a scale of 9 required for ranking APCs.
   */
  @JsonIgnore
  public final BigDecimal getReimbursementRanking() {
    return calculateReimbursementRate();
  }

  /**
   * This method is based on the 'PROCESSING FOR CALCULATING APC REIMBURSEMENT % AND RANKS' section
   * of the APCSCOPY SAS script which creates the OPPSAPCS copybook. The SAS script ranks entries
   * based on a calculated percent which may include values with a scale as high as 9. In all cases,
   * the script writes the copybook value for calculation purposes with a scale of 6. This method
   * mimics this behavior which will require callers of this method to scale accordingly.
   *
   * @return calculated percent of 75%, 80%, 100% or COIN/RATE
   */
  @JsonIgnore
  private BigDecimal calculateReimbursementRate() {
    // If StatusIndicator is H1, return 80% - Added for CY 2025
    if (statusIndicator.contains(StatusIndicator.H1_NON_OPIOID_MEDICAL_DEVICE.getIndicator())) {
      return PERCENT_80;
    } else if (paymentRate == null || BigDecimalUtils.isZero(paymentRate)) {
      return PERCENT_100;
    } else if (StringUtils.equalsAny(apc, "00158", "00159")) {
      return PERCENT_75;
    } else if (BigDecimalUtils.isZero(getNationalCoinsurance())) {
      return PERCENT_100;
    } else if (BigDecimalUtils.equals(getNationalCoinsurance(), paymentRate.multiply(new BigDecimal(".2")).setScale(2, RoundingMode.HALF_UP))) {
      return PERCENT_80;
    } else {
      // Scale must be 9 in order to generate the same ranking order as APCSCOPY
      return BigDecimal.ONE.subtract(getNationalCoinsurance().divide(paymentRate, 9, RoundingMode.HALF_UP));
    }
  }

  public ApcRateHistoryEntryBuilder copyBuilder() {
    return ApcRateHistoryEntry.builder().apc(getApc()).statusIndicator(getStatusIndicator()).effectiveDate(getEffectiveDate()).paymentRate(getPaymentRate()).nationalCoinsurance(getNationalCoinsurance()).minimumCoinsurance(getMinimumCoinsurance()).rank(getRank());
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  ApcRateHistoryEntry(final String apc, final String statusIndicator, final LocalDate effectiveDate, final BigDecimal paymentRate, final BigDecimal nationalCoinsurance, final BigDecimal minimumCoinsurance, final Integer rank) {
    this.apc = apc;
    this.statusIndicator = statusIndicator;
    this.effectiveDate = effectiveDate;
    this.paymentRate = paymentRate;
    this.nationalCoinsurance = nationalCoinsurance;
    this.minimumCoinsurance = minimumCoinsurance;
    this.rank = rank;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static ApcRateHistoryEntry.ApcRateHistoryEntryBuilder builder() {
    return new ApcRateHistoryEntry.ApcRateHistoryEntryBuilder();
  }

  /**
   * Corresponds to {@code WAA-APC PIC 9(5)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getApc() {
    return this.apc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatusIndicator() {
    return this.statusIndicator;
  }

  /**
   * Corresponds to {@code WAD-DATE PIC X(8)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getEffectiveDate() {
    return this.effectiveDate;
  }

  /**
   * Corresponds to {@code WAR-RATE PIC 9(6)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPaymentRate() {
    return this.paymentRate;
  }

  /**
   * Corresponds to {@code WAR-COIN PIC 9(5)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalCoinsurance() {
    return this.nationalCoinsurance;
  }

  /**
   * Corresponds to {@code WAR-MINC PIC 9(5)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getMinimumCoinsurance() {
    return this.minimumCoinsurance;
  }

  /**
   * Corresponds to {@code WAR-RANK PIC 9(5)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getRank() {
    return this.rank;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String APC = "apc";
    public static final java.lang.String STATUS_INDICATOR = "statusIndicator";
    public static final java.lang.String EFFECTIVE_DATE = "effectiveDate";
    public static final java.lang.String PAYMENT_RATE = "paymentRate";
    public static final java.lang.String NATIONAL_COINSURANCE = "nationalCoinsurance";
    public static final java.lang.String MINIMUM_COINSURANCE = "minimumCoinsurance";
    public static final java.lang.String RANK = "rank";
  }
}
