// Generated by delombok at Mon Dec 08 20:51:35 UTC 2025
package gov.cms.fiss.pricers.opps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.opps.OppsPricerConfiguration;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * This class is responsible for holding all the CopyBook data tables for the pricer as well as
 *
 * <p>helper methods to access the data.
 */
public class DataTables {
  private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<>();
  /**
   * W-APC-RATE-TABLE lookup table.
   */
  private final Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> apcRateHistory;
  /**
   * W-WNXC-WNXC-TABLE lookup table.
   */
  private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
  /**
   * OUTM-TAB lookup table.
   */
  private final Map<Integer, NavigableMap<LocalDate, OutMigrationAdjustmentEntry>> outMigrationAdjustmentMap;
  /**
   * PREV-TAB lookup table.
   */
  private final Map<String, PreviousYearWageIndexEntry> previousYearWageIndexMap;
  /**
   * W-2020-BLOOD-APC-TABLE lookup table.
   */
  private final Map<String, BloodRankEntry> bloodRankMap;
  /**
   * Provider CCN 340B lookup set.
   */
  private final Set<String> providerCcn340BSet;

  public DataTables(Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> apcRateHistory, Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<String, BloodRankEntry> bloodRankMap, Map<Integer, NavigableMap<LocalDate, OutMigrationAdjustmentEntry>> outMigrationAdjustmentMap, Map<String, PreviousYearWageIndexEntry> previousYearWageIndexMap, Set<String> providerCcn340BSet) {
    this.apcRateHistory = apcRateHistory;
    this.cbsaTable = cbsaTable;
    this.bloodRankMap = bloodRankMap;
    this.outMigrationAdjustmentMap = outMigrationAdjustmentMap;
    this.previousYearWageIndexMap = previousYearWageIndexMap;
    this.providerCcn340BSet = providerCcn340BSet;
  }

  public static DataTables forYear(int pricerYear) {
    return YEAR_LOOKUP.get(pricerYear);
  }

  /**
   * Loads data tables with the given CSV ingestion configuration.
   */
  public static void loadDataTables(OppsPricerConfiguration pricerConfiguration) {
    final CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
    final ApcRateHistoryLookupGenerator apcRateHistoryLookupGenerator = new ApcRateHistoryLookupGenerator(csvIngestionConfiguration);
    final CbsaWageIndexLookupGenerator cbsaWageIndexLookupGenerator = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
    final BloodRankLookupGenerator bloodRankLookupGenerator = new BloodRankLookupGenerator(csvIngestionConfiguration);
    final OutMigrationAdjustmentLookupGenerator outMigrationAdjustmentLookupGenerator = new OutMigrationAdjustmentLookupGenerator(csvIngestionConfiguration);
    final ProviderCcn340BLookupGenerator providerCcn340BLookupGenerator = new ProviderCcn340BLookupGenerator(csvIngestionConfiguration);
    final Map<String, PreviousYearWageIndexEntry> previousYearWageIndexMap;
    // Use override value if present else default
    if (pricerConfiguration.getPreviousYearWageIndexOverride() != null) {
      previousYearWageIndexMap = new PreviousYearWageIndexLookupGenerator(csvIngestionConfiguration).generate(pricerConfiguration.getPreviousYearWageIndexOverride());
    } else {
      previousYearWageIndexMap = new PreviousYearWageIndexLookupGenerator(csvIngestionConfiguration).generate();
    }
    // Load Provider CCN 340B data once (same for all years)
    final Set<String> providerCcn340BSet = providerCcn340BLookupGenerator.generate();
    // Load all the tables
    for (final int pricerYear : pricerConfiguration.getSupportedYears()) {
      YEAR_LOOKUP.put(pricerYear, new DataTables(apcRateHistoryLookupGenerator.generate(pricerYear), cbsaWageIndexLookupGenerator.generate(pricerYear), bloodRankLookupGenerator.generate(pricerYear), outMigrationAdjustmentLookupGenerator.generate(pricerYear), previousYearWageIndexMap, providerCcn340BSet));
    }
  }

  /**
   * Returns the APC rates table for iteration.
   *
   * @return All the APC rate entries
   */
  public Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> getApcRateHistoryTable() {
    return apcRateHistory;
  }

  /**
   * Returns the APC rates for the given payment APC.
   *
   * @param paymentApc APC to be used
   * @return APC rate entries if found otherwise null
   */
  public NavigableMap<LocalDate, ApcRateHistoryEntry> getApcRateHistoryEntry(String paymentApc) {
    // LOOK-UP LINE APC IN APC TABLE FOR ALL LINES THAT - PASS VALIDATION RULES
    return apcRateHistory.get(paymentApc);
  }

  /**
   * Wage index lookup based on CBSA.
   *
   * @param cbsa CBSA to be looked up
   * @return CBSA wage index entries if found otherwise null
   */
  public NavigableMap<LocalDate, CbsaWageIndexEntry> getCbsaWageIndexEntries(String cbsa) {
    return cbsaTable.get(cbsa);
  }

  /**
   * Returns blood ranking for the given HCPCS code.
   */
  public Integer getBloodRank(String hcpcsCode) {
    final BloodRankEntry entry = bloodRankMap.get(hcpcsCode);
    return entry == null ? null : entry.getRank();
  }

  /**
   * DETERMINE WHETHER THE CURRENT HCPCS IS A BLOOD DEDUCTIBLE.
   *
   * <p>(19655-SET-BD-HCPCS-FLAG - Replaces BLD-DEDUC-HCPCS-FLAG)
   */
  public boolean isBloodHcpcsDeductible(String hcpcs) {
    return bloodRankMap.containsKey(hcpcs);
  }

  /**
   * Checks if the given provider CCN is in the 340B list.
   *
   * @param providerCcn the provider CCN to check
   * @return true if the provider CCN is in the 340B list, false otherwise
   */
  public boolean isProviderCcn340B(String providerCcn) {
    return providerCcn340BSet != null && providerCcn340BSet.contains(providerCcn);
  }

  /**
   * Returns the out migration adjustment for the given county and service date.
   *
   * @param county the county code
   * @param serviceDate the service date
   * @return the out migration adjustment entry if found, null otherwise
   */
  public OutMigrationAdjustmentEntry getOutMigrationAdjustment(int county, LocalDate serviceDate) {
    final NavigableMap<LocalDate, OutMigrationAdjustmentEntry> entries = outMigrationAdjustmentMap.get(county);
    if (entries == null) {
      return null;
    }
    final Entry<LocalDate, OutMigrationAdjustmentEntry> entry = entries.floorEntry(serviceDate);
    return entry == null ? null : entry.getValue();
  }

  /**
   * Returns the prior year wage index for the given provider number.
   *
   * @param providerNumber the provider number
   * @return the prior year wage index if found, null otherwise
   */
  public BigDecimal getPriorYearWageIndex(String providerNumber) {
    final PreviousYearWageIndexEntry entry = previousYearWageIndexMap.get(providerNumber);
    return entry == null ? null : entry.getWageIndex();
  }

  /**
   * W-WNXC-WNXC-TABLE lookup table.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
    return this.cbsaTable;
  }
}
