/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.csv;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;

public final class LookupGenerator {
    public static <K, V, U> Map<K, List<U>> generateCrossReferenceToList(Function<V, K> keyGenerator, Collection<V> values, Collector<V, ?, List<U>> collector) {
        return LookupGenerator.generateCrossReferenceToList(keyGenerator, values, HashMap::new, collector);
    }

    public static <K, V, U, M extends Map<K, List<U>>> Map<K, List<U>> generateCrossReferenceToList(Function<V, K> keyGenerator, Collection<V> values, Supplier<M> mapSupplier, Collector<V, ?, List<U>> collector) {
        if (null == values) {
            return (Map)mapSupplier.get();
        }
        return (Map)values.stream().collect(Collectors.groupingBy(keyGenerator, mapSupplier, collector));
    }

    public static <K, J, V, U, N extends Map<J, U>> Map<K, N> generateCrossReferenceToMap(Function<V, K> keyGenerator, Collection<V> values, Collector<V, ?, N> collector) {
        return LookupGenerator.generateCrossReferenceToMap(keyGenerator, values, HashMap::new, collector);
    }

    public static <K, J, V, U, M extends Map<K, N>, N extends Map<J, U>> Map<K, N> generateCrossReferenceToMap(Function<V, K> keyGenerator, Collection<V> values, Supplier<M> mapSupplier, Collector<V, ?, N> collector) {
        if (null == values) {
            return (Map)mapSupplier.get();
        }
        return (Map)values.stream().collect(Collectors.groupingBy(keyGenerator, mapSupplier, collector));
    }

    public static <K, V> Map<K, List<V>> generateCrossReferenceToReverseSortedList(Function<V, K> keyGenerator, Collection<V> values) {
        return LookupGenerator.generateCrossReferenceToReverseSortedList(keyGenerator, values, HashMap::new);
    }

    public static <K, V, M extends Map<K, List<V>>> Map<K, List<V>> generateCrossReferenceToReverseSortedList(Function<V, K> keyGenerator, Collection<V> values, Supplier<M> mapSupplier) {
        return LookupGenerator.generateCrossReferenceToSortedList(keyGenerator, values, mapSupplier, Collections.reverseOrder());
    }

    public static <K, V> Map<K, Set<V>> generateCrossReferenceToReverseSortedSet(Function<V, K> keyGenerator, Collection<V> values) {
        return LookupGenerator.generateCrossReferenceToReverseSortedSet(keyGenerator, values, HashMap::new);
    }

    public static <K, V, M extends Map<K, Set<V>>> Map<K, Set<V>> generateCrossReferenceToReverseSortedSet(Function<V, K> keyGenerator, Collection<V> values, Supplier<M> mapSupplier) {
        return LookupGenerator.generateCrossReferenceToSortedSet(keyGenerator, values, mapSupplier, Collections.reverseOrder());
    }

    public static <K, V, U> Map<K, Set<U>> generateCrossReferenceToSet(Function<V, K> keyGenerator, Collection<V> values, Collector<V, ?, Set<U>> collector) {
        return LookupGenerator.generateCrossReferenceToSet(keyGenerator, values, HashMap::new, collector);
    }

    public static <K, V, U, M extends Map<K, Set<U>>> Map<K, Set<U>> generateCrossReferenceToSet(Function<V, K> keyGenerator, Collection<V> values, Supplier<M> mapSupplier, Collector<V, ?, Set<U>> collector) {
        if (null == values) {
            return (Map)mapSupplier.get();
        }
        return (Map)values.stream().collect(Collectors.groupingBy(keyGenerator, mapSupplier, collector));
    }

    public static <K, V> Map<K, List<V>> generateCrossReferenceToSortedList(Function<V, K> keyGenerator, Collection<V> values) {
        Supplier<Map> mapSupplier = HashMap::new;
        return LookupGenerator.generateCrossReferenceToSortedList(keyGenerator, values, mapSupplier);
    }

    public static <K, V, M extends Map<K, List<V>>> Map<K, List<V>> generateCrossReferenceToSortedList(Function<V, K> keyGenerator, Collection<V> values, Supplier<M> mapSupplier) {
        return LookupGenerator.generateCrossReferenceToList(keyGenerator, values, mapSupplier, Collectors.mapping(Function.identity(), LookupGenerator.toDefaultSortedList()));
    }

    private static <T> Collector<T, ?, List<T>> toDefaultSortedList() {
        return Collectors.collectingAndThen(Collectors.toList(), l -> l.stream().sorted().collect(Collectors.toList()));
    }

    public static <K, V> Map<K, List<V>> generateCrossReferenceToSortedList(Function<V, K> keyGenerator, Collection<V> values, Comparator<V> comparator) {
        return LookupGenerator.generateCrossReferenceToSortedList(keyGenerator, values, HashMap::new, comparator);
    }

    public static <K, V, M extends Map<K, List<V>>> Map<K, List<V>> generateCrossReferenceToSortedList(Function<V, K> keyGenerator, Collection<V> values, Supplier<M> mapSupplier, Comparator<V> comparator) {
        return LookupGenerator.generateCrossReferenceToList(keyGenerator, values, mapSupplier, Collectors.mapping(Function.identity(), LookupGenerator.toDefaultSortedList(comparator)));
    }

    private static <T> Collector<T, ?, List<T>> toDefaultSortedList(Comparator<T> comparator) {
        return Collectors.collectingAndThen(Collectors.toList(), l -> l.stream().sorted(comparator).collect(Collectors.toList()));
    }

    public static <K, V> Map<K, Set<V>> generateCrossReferenceToSortedSet(Function<V, K> keyGenerator, Collection<V> values) {
        Supplier<Map> mapSupplier = HashMap::new;
        return LookupGenerator.generateCrossReferenceToSortedSet(keyGenerator, values, mapSupplier);
    }

    public static <K, V, M extends Map<K, Set<V>>> Map<K, Set<V>> generateCrossReferenceToSortedSet(Function<V, K> keyGenerator, Collection<V> values, Supplier<M> mapSupplier) {
        return LookupGenerator.generateCrossReferenceToSet(keyGenerator, values, mapSupplier, Collectors.mapping(Function.identity(), Collectors.toCollection(TreeSet::new)));
    }

    public static <K, V> Map<K, Set<V>> generateCrossReferenceToSortedSet(Function<V, K> keyGenerator, Collection<V> values, Comparator<V> comparator) {
        return LookupGenerator.generateCrossReferenceToSortedSet(keyGenerator, values, HashMap::new, comparator);
    }

    public static <K, V, M extends Map<K, Set<V>>> Map<K, Set<V>> generateCrossReferenceToSortedSet(Function<V, K> keyGenerator, Collection<V> values, Supplier<M> mapSupplier, Comparator<V> comparator) {
        return LookupGenerator.generateCrossReferenceToSet(keyGenerator, values, mapSupplier, Collectors.mapping(Function.identity(), Collectors.toCollection(() -> new TreeSet(comparator))));
    }

    public static <K, V> Map<K, V> generateMap(Function<V, K> keyGenerator, Collection<V> values) {
        return LookupGenerator.generateMap(keyGenerator, values, HashMap::new);
    }

    public static <K, V, M extends Map<K, V>> M generateMap(Function<V, K> keyGenerator, Collection<V> values, Supplier<M> mapSupplier) {
        return LookupGenerator.generateMap(keyGenerator, Function.identity(), values, mapSupplier);
    }

    public static <K, V, U> Map<K, U> generateMap(Function<V, K> keyGenerator, Function<V, U> valueProvider, Collection<V> values) {
        return LookupGenerator.generateMap(keyGenerator, valueProvider, values, HashMap::new);
    }

    public static <K, V, U, M extends Map<K, U>> M generateMap(Function<V, K> keyGenerator, Function<V, U> valueProvider, Collection<V> values, Supplier<M> mapSupplier) {
        Map map = (Map)mapSupplier.get();
        if (null != values) {
            values.forEach(content -> map.put(keyGenerator.apply(content), valueProvider.apply(content)));
        }
        return (M)map;
    }

    @Generated
    private LookupGenerator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

