/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

@Schema(description="The IOCE service line information.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-OCE-LINE", value="<structure>"), @ExtensionProperty(name="OCE-IN-LINES", value="<structure>")})})
public class IoceServiceLineData {
    @Pattern(regexp="[A-Z\\d]", message="must be alphanumeric")
    @Schema(description="The flag that identifies an override to a line item denial/rejection or to allow the MAC to indicate the line item should be denied/rejected.", example="1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-LITEM-ACT-FLAG", value="PIC X(01)")})})
    private @Pattern(regexp="[A-Z\\d]", message="must be alphanumeric") String actionFlag;
    @Max(value=999999999L)
    @Min(value=0L)
    @Schema(description="The quantitative measure of services rendered to or for the patient by Healthcare Common Procedure Coding System (HCPCS) code.", example="1827", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-SRVC-UNITS", value="PIC 9(09)")})})
    private @Max(value=999999999L) @Min(value=0L) int apcServiceUnits;
    @Pattern(regexp="\\d{2}", message="must be two digits")
    @Schema(description="The composite adjustment flag.", example="00", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-COMP-ADJ-FLAG", value="PIC X(02)")})})
    private @Pattern(regexp="\\d{2}", message="must be two digits") String compositeAdjustmentFlag;
    @BigDecimalScale
    @DecimalMax(value="99999999.99")
    @DecimalMin(value="0")
    @Digits(integer=8, fraction=2)
    @Schema(description="The charges related to the revenue or Healthcare Common Procedure Coding System (HCPCS) procedure codes for the current billing period.", example="93845.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-SUB-CHRG", value="PIC 9(08)V99")})})
    private @DecimalMax(value="99999999.99") @DecimalMin(value="0") @Digits(integer=8, fraction=2) BigDecimal coveredCharges = BigDecimalUtils.ZERO;
    @Schema(description="The date of service.", example="2020-05-13", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-LITEM-DOS", value="PIC 9(08)")})})
    @StrictLocalDate
    private LocalDate dateOfService;
    @Pattern(regexp="[A-Z\\d]", message="must be alphanumeric")
    @Schema(description="The indicator that signifies if the line item was denied or rejected.", example="0", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-LITEM-DR-FLAG", value="PIC X(01)")})})
    private @Pattern(regexp="[A-Z\\d]", message="must be alphanumeric") String denyOrRejectFlag;
    @Max(value=9L)
    @Min(value=0L)
    @Schema(description="The identifier of the discounting formula that was applied.", example="1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-DISC-FACT", value="PIC 9(01)")})})
    private @Max(value=9L) @Min(value=0L) int discountingFormula;
    @Pattern(regexp="\\d{5}", message="must be five digits")
    @Schema(description="The ambulatory payment classification (APC) assigned to the HCPCS procedure code.", example="05521", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-HCPCS-APC", value="PIC X(05)")})})
    private @Pattern(regexp="\\d{5}", message="must be five digits") String hcpcsApc;
    @Pattern(regexp="[A-Z\\d]{5}", message="must be five alphanumeric characters")
    @Schema(description="The Healthcare Common Procedure Coding System (HCPCS) code associated with the procedure.", example="70551", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-HCPCS", value="PIC X(05)")})})
    private @Pattern(regexp="[A-Z\\d]{5}", message="must be five alphanumeric characters") String hcpcsCode;
    @ArraySchema(arraySchema=@Schema(description="The Healthcare Common Procedure Coding System (HCPCS) code modifiers.", example="[\"95\", \"99\"]"), uniqueItems=true)
    @Size(max=6, min=1)
    private @Size(max=6, min=1) List<@Pattern(regexp="@[A-Z\\d]|[A-Z\\d]{2}|#[A-Z\\d]", message="must be two alphanumeric characters, or a '@' followed by an alphanumeric character, or a '#' followed by an alphanumeric character.") String> hcpcsModifiers;
    @Max(value=450L)
    @Min(value=1L)
    @NotNull
    @Schema(description="The index of the service line within the claim data.")
    private @Max(value=450L) @Min(value=1L) @NotNull Integer lineNumber;
    @Pattern(regexp="\\d", message="must be a digit")
    @Schema(description="The flag that identifies the inclusion of certain ancillary services performed as part of a visit into the APC payment rate for a significant procedure or medical visit.", example="3", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-PKG-FLAG", value="PIC X(01)")})})
    private @Pattern(regexp="\\d", message="must be a digit") String packageFlag;
    @ArraySchema(arraySchema=@Schema(description="The flags that identify the type of payment adjustment(s) applied.", example="[\"1\",\"23\"]", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-PYMT-ADJ-FLAG", value="PIC X(02)")})}), uniqueItems=true)
    @Size(max=2, min=1)
    private @Size(max=2, min=1) List<@NotNull @Pattern(regexp="\\d{1,2}", message="must be one or two digits") String> paymentAdjustmentFlags;
    @Pattern(regexp="\\d{5}", message="must be five digits")
    @Schema(description="The ambulatory payment classification (APC) assigned for payment.", example="05523", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-GRP", value="PIC X(05)")})})
    private @Pattern(regexp="\\d{5}", message="must be five digits") String paymentApc = "00000";
    @Pattern(regexp="\\d{1,2}", message="must be one or two digits")
    @Schema(description="The indicator that signifies whether the service payment was made in whole, in part or denied.", example="5", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-PYMT-IND", value="PIC X(02)")})})
    private @Pattern(regexp="\\d{1,2}", message="must be one or two digits") String paymentIndicator;
    @Pattern(regexp="[A-Z\\d]", message="must be a digit or upper-case letter")
    @Schema(description="The payment method flag denoting how the payment was determined.", example="0", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-SITE-SRVC-FLAG", value="PIC X(01)")})})
    private @Pattern(regexp="[A-Z\\d]", message="must be a digit or upper-case letter") String paymentMethodFlag;
    @NotNull
    @Pattern(regexp="\\d{4}", message="must be four digits")
    @Schema(description="The code that identifies a specific accommodation, ancillary service, or billing calculation.", example="0320", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-LITEM-RVCD", value="PIC X(04)")})})
    private @NotNull @Pattern(regexp="\\d{4}", message="must be four digits") String revenueCode;
    @Pattern(regexp="[A-Z]\\d?", message="must be one alphanumeric character optionally followed by a digit")
    @Schema(description="The indicator that signifies whether Medicare will reimburse the service and how it will be reimbursed. The indicator also helps in determining whether policy rules (such as packaging and discounting) apply.", example="J1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OPPS-SRVC-IND", value="PIC X(02)")})})
    private @Pattern(regexp="[A-Z]\\d?", message="must be one alphanumeric character optionally followed by a digit") String statusIndicator;

    @Generated
    public String getActionFlag() {
        return this.actionFlag;
    }

    @Generated
    public int getApcServiceUnits() {
        return this.apcServiceUnits;
    }

    @Generated
    public String getCompositeAdjustmentFlag() {
        return this.compositeAdjustmentFlag;
    }

    @Generated
    public BigDecimal getCoveredCharges() {
        return this.coveredCharges;
    }

    @Generated
    public LocalDate getDateOfService() {
        return this.dateOfService;
    }

    @Generated
    public String getDenyOrRejectFlag() {
        return this.denyOrRejectFlag;
    }

    @Generated
    public int getDiscountingFormula() {
        return this.discountingFormula;
    }

    @Generated
    public String getHcpcsApc() {
        return this.hcpcsApc;
    }

    @Generated
    public String getHcpcsCode() {
        return this.hcpcsCode;
    }

    @Generated
    public List<@Pattern(regexp="@[A-Z\\d]|[A-Z\\d]{2}|#[A-Z\\d]", message="must be two alphanumeric characters, or a '@' followed by an alphanumeric character, or a '#' followed by an alphanumeric character.") String> getHcpcsModifiers() {
        return this.hcpcsModifiers;
    }

    @Generated
    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Generated
    public String getPackageFlag() {
        return this.packageFlag;
    }

    @Generated
    public List<@NotNull @Pattern(regexp="\\d{1,2}", message="must be one or two digits") String> getPaymentAdjustmentFlags() {
        return this.paymentAdjustmentFlags;
    }

    @Generated
    public String getPaymentApc() {
        return this.paymentApc;
    }

    @Generated
    public String getPaymentIndicator() {
        return this.paymentIndicator;
    }

    @Generated
    public String getPaymentMethodFlag() {
        return this.paymentMethodFlag;
    }

    @Generated
    public String getRevenueCode() {
        return this.revenueCode;
    }

    @Generated
    public String getStatusIndicator() {
        return this.statusIndicator;
    }

    @Generated
    public void setActionFlag(String actionFlag) {
        this.actionFlag = actionFlag;
    }

    @Generated
    public void setApcServiceUnits(int apcServiceUnits) {
        this.apcServiceUnits = apcServiceUnits;
    }

    @Generated
    public void setCompositeAdjustmentFlag(String compositeAdjustmentFlag) {
        this.compositeAdjustmentFlag = compositeAdjustmentFlag;
    }

    @Generated
    public void setCoveredCharges(BigDecimal coveredCharges) {
        this.coveredCharges = coveredCharges;
    }

    @Generated
    public void setDateOfService(LocalDate dateOfService) {
        this.dateOfService = dateOfService;
    }

    @Generated
    public void setDenyOrRejectFlag(String denyOrRejectFlag) {
        this.denyOrRejectFlag = denyOrRejectFlag;
    }

    @Generated
    public void setDiscountingFormula(int discountingFormula) {
        this.discountingFormula = discountingFormula;
    }

    @Generated
    public void setHcpcsApc(String hcpcsApc) {
        this.hcpcsApc = hcpcsApc;
    }

    @Generated
    public void setHcpcsCode(String hcpcsCode) {
        this.hcpcsCode = hcpcsCode;
    }

    @Generated
    public void setHcpcsModifiers(List<@Pattern(regexp="@[A-Z\\d]|[A-Z\\d]{2}|#[A-Z\\d]", message="must be two alphanumeric characters, or a '@' followed by an alphanumeric character, or a '#' followed by an alphanumeric character.") String> hcpcsModifiers) {
        this.hcpcsModifiers = hcpcsModifiers;
    }

    @Generated
    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Generated
    public void setPackageFlag(String packageFlag) {
        this.packageFlag = packageFlag;
    }

    @Generated
    public void setPaymentAdjustmentFlags(List<@NotNull @Pattern(regexp="\\d{1,2}", message="must be one or two digits") String> paymentAdjustmentFlags) {
        this.paymentAdjustmentFlags = paymentAdjustmentFlags;
    }

    @Generated
    public void setPaymentApc(String paymentApc) {
        this.paymentApc = paymentApc;
    }

    @Generated
    public void setPaymentIndicator(String paymentIndicator) {
        this.paymentIndicator = paymentIndicator;
    }

    @Generated
    public void setPaymentMethodFlag(String paymentMethodFlag) {
        this.paymentMethodFlag = paymentMethodFlag;
    }

    @Generated
    public void setRevenueCode(String revenueCode) {
        this.revenueCode = revenueCode;
    }

    @Generated
    public void setStatusIndicator(String statusIndicator) {
        this.statusIndicator = statusIndicator;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IoceServiceLineData)) {
            return false;
        }
        IoceServiceLineData other = (IoceServiceLineData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getApcServiceUnits() != other.getApcServiceUnits()) {
            return false;
        }
        if (this.getDiscountingFormula() != other.getDiscountingFormula()) {
            return false;
        }
        Integer this$lineNumber = this.getLineNumber();
        Integer other$lineNumber = other.getLineNumber();
        if (this$lineNumber == null ? other$lineNumber != null : !((Object)this$lineNumber).equals(other$lineNumber)) {
            return false;
        }
        String this$actionFlag = this.getActionFlag();
        String other$actionFlag = other.getActionFlag();
        if (this$actionFlag == null ? other$actionFlag != null : !this$actionFlag.equals(other$actionFlag)) {
            return false;
        }
        String this$compositeAdjustmentFlag = this.getCompositeAdjustmentFlag();
        String other$compositeAdjustmentFlag = other.getCompositeAdjustmentFlag();
        if (this$compositeAdjustmentFlag == null ? other$compositeAdjustmentFlag != null : !this$compositeAdjustmentFlag.equals(other$compositeAdjustmentFlag)) {
            return false;
        }
        BigDecimal this$coveredCharges = this.getCoveredCharges();
        BigDecimal other$coveredCharges = other.getCoveredCharges();
        if (this$coveredCharges == null ? other$coveredCharges != null : !((Object)this$coveredCharges).equals(other$coveredCharges)) {
            return false;
        }
        LocalDate this$dateOfService = this.getDateOfService();
        LocalDate other$dateOfService = other.getDateOfService();
        if (this$dateOfService == null ? other$dateOfService != null : !((Object)this$dateOfService).equals(other$dateOfService)) {
            return false;
        }
        String this$denyOrRejectFlag = this.getDenyOrRejectFlag();
        String other$denyOrRejectFlag = other.getDenyOrRejectFlag();
        if (this$denyOrRejectFlag == null ? other$denyOrRejectFlag != null : !this$denyOrRejectFlag.equals(other$denyOrRejectFlag)) {
            return false;
        }
        String this$hcpcsApc = this.getHcpcsApc();
        String other$hcpcsApc = other.getHcpcsApc();
        if (this$hcpcsApc == null ? other$hcpcsApc != null : !this$hcpcsApc.equals(other$hcpcsApc)) {
            return false;
        }
        String this$hcpcsCode = this.getHcpcsCode();
        String other$hcpcsCode = other.getHcpcsCode();
        if (this$hcpcsCode == null ? other$hcpcsCode != null : !this$hcpcsCode.equals(other$hcpcsCode)) {
            return false;
        }
        List<String> this$hcpcsModifiers = this.getHcpcsModifiers();
        List<String> other$hcpcsModifiers = other.getHcpcsModifiers();
        if (this$hcpcsModifiers == null ? other$hcpcsModifiers != null : !((Object)this$hcpcsModifiers).equals(other$hcpcsModifiers)) {
            return false;
        }
        String this$packageFlag = this.getPackageFlag();
        String other$packageFlag = other.getPackageFlag();
        if (this$packageFlag == null ? other$packageFlag != null : !this$packageFlag.equals(other$packageFlag)) {
            return false;
        }
        List<String> this$paymentAdjustmentFlags = this.getPaymentAdjustmentFlags();
        List<String> other$paymentAdjustmentFlags = other.getPaymentAdjustmentFlags();
        if (this$paymentAdjustmentFlags == null ? other$paymentAdjustmentFlags != null : !((Object)this$paymentAdjustmentFlags).equals(other$paymentAdjustmentFlags)) {
            return false;
        }
        String this$paymentApc = this.getPaymentApc();
        String other$paymentApc = other.getPaymentApc();
        if (this$paymentApc == null ? other$paymentApc != null : !this$paymentApc.equals(other$paymentApc)) {
            return false;
        }
        String this$paymentIndicator = this.getPaymentIndicator();
        String other$paymentIndicator = other.getPaymentIndicator();
        if (this$paymentIndicator == null ? other$paymentIndicator != null : !this$paymentIndicator.equals(other$paymentIndicator)) {
            return false;
        }
        String this$paymentMethodFlag = this.getPaymentMethodFlag();
        String other$paymentMethodFlag = other.getPaymentMethodFlag();
        if (this$paymentMethodFlag == null ? other$paymentMethodFlag != null : !this$paymentMethodFlag.equals(other$paymentMethodFlag)) {
            return false;
        }
        String this$revenueCode = this.getRevenueCode();
        String other$revenueCode = other.getRevenueCode();
        if (this$revenueCode == null ? other$revenueCode != null : !this$revenueCode.equals(other$revenueCode)) {
            return false;
        }
        String this$statusIndicator = this.getStatusIndicator();
        String other$statusIndicator = other.getStatusIndicator();
        return !(this$statusIndicator == null ? other$statusIndicator != null : !this$statusIndicator.equals(other$statusIndicator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IoceServiceLineData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getApcServiceUnits();
        result = result * 59 + this.getDiscountingFormula();
        Integer $lineNumber = this.getLineNumber();
        result = result * 59 + ($lineNumber == null ? 43 : ((Object)$lineNumber).hashCode());
        String $actionFlag = this.getActionFlag();
        result = result * 59 + ($actionFlag == null ? 43 : $actionFlag.hashCode());
        String $compositeAdjustmentFlag = this.getCompositeAdjustmentFlag();
        result = result * 59 + ($compositeAdjustmentFlag == null ? 43 : $compositeAdjustmentFlag.hashCode());
        BigDecimal $coveredCharges = this.getCoveredCharges();
        result = result * 59 + ($coveredCharges == null ? 43 : ((Object)$coveredCharges).hashCode());
        LocalDate $dateOfService = this.getDateOfService();
        result = result * 59 + ($dateOfService == null ? 43 : ((Object)$dateOfService).hashCode());
        String $denyOrRejectFlag = this.getDenyOrRejectFlag();
        result = result * 59 + ($denyOrRejectFlag == null ? 43 : $denyOrRejectFlag.hashCode());
        String $hcpcsApc = this.getHcpcsApc();
        result = result * 59 + ($hcpcsApc == null ? 43 : $hcpcsApc.hashCode());
        String $hcpcsCode = this.getHcpcsCode();
        result = result * 59 + ($hcpcsCode == null ? 43 : $hcpcsCode.hashCode());
        List<String> $hcpcsModifiers = this.getHcpcsModifiers();
        result = result * 59 + ($hcpcsModifiers == null ? 43 : ((Object)$hcpcsModifiers).hashCode());
        String $packageFlag = this.getPackageFlag();
        result = result * 59 + ($packageFlag == null ? 43 : $packageFlag.hashCode());
        List<String> $paymentAdjustmentFlags = this.getPaymentAdjustmentFlags();
        result = result * 59 + ($paymentAdjustmentFlags == null ? 43 : ((Object)$paymentAdjustmentFlags).hashCode());
        String $paymentApc = this.getPaymentApc();
        result = result * 59 + ($paymentApc == null ? 43 : $paymentApc.hashCode());
        String $paymentIndicator = this.getPaymentIndicator();
        result = result * 59 + ($paymentIndicator == null ? 43 : $paymentIndicator.hashCode());
        String $paymentMethodFlag = this.getPaymentMethodFlag();
        result = result * 59 + ($paymentMethodFlag == null ? 43 : $paymentMethodFlag.hashCode());
        String $revenueCode = this.getRevenueCode();
        result = result * 59 + ($revenueCode == null ? 43 : $revenueCode.hashCode());
        String $statusIndicator = this.getStatusIndicator();
        result = result * 59 + ($statusIndicator == null ? 43 : $statusIndicator.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IoceServiceLineData(actionFlag=" + this.getActionFlag() + ", apcServiceUnits=" + this.getApcServiceUnits() + ", compositeAdjustmentFlag=" + this.getCompositeAdjustmentFlag() + ", coveredCharges=" + this.getCoveredCharges() + ", dateOfService=" + this.getDateOfService() + ", denyOrRejectFlag=" + this.getDenyOrRejectFlag() + ", discountingFormula=" + this.getDiscountingFormula() + ", hcpcsApc=" + this.getHcpcsApc() + ", hcpcsCode=" + this.getHcpcsCode() + ", hcpcsModifiers=" + this.getHcpcsModifiers() + ", lineNumber=" + this.getLineNumber() + ", packageFlag=" + this.getPackageFlag() + ", paymentAdjustmentFlags=" + this.getPaymentAdjustmentFlags() + ", paymentApc=" + this.getPaymentApc() + ", paymentIndicator=" + this.getPaymentIndicator() + ", paymentMethodFlag=" + this.getPaymentMethodFlag() + ", revenueCode=" + this.getRevenueCode() + ", statusIndicator=" + this.getStatusIndicator() + ")";
    }

    @Generated
    public IoceServiceLineData() {
    }
}

