/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.ServiceLineContext;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import java.util.List;

public class InitializeAndValidateLines
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    private final EvaluatingCalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> ruleEvaluator;

    public InitializeAndValidateLines(List<CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext>> rules) {
        this.ruleEvaluator = new EvaluatingCalculationRule(rules);
    }

    @Override
    public void calculate(OppsPricerContext context) {
        List<IoceServiceLineData> lines = context.getClaimData().getIoceServiceLines();
        for (IoceServiceLineData serviceLine : lines) {
            if (serviceLine.getHcpcsCode() == null) {
                serviceLine.setHcpcsCode("");
            }
            ServiceLinePaymentData serviceLineOutput = context.getServiceLinePaymentByLineNumber(serviceLine.getLineNumber());
            ServiceLineContext serviceLineContext = new ServiceLineContext(context, serviceLine, serviceLineOutput);
            serviceLineContext.applyLineReturnCode(ReturnCode.PROCESSED_1);
            this.ruleEvaluator.calculate(serviceLineContext);
        }
    }
}

