/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.codes.PaymentIndicator;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import java.util.List;
import java.util.stream.Stream;

public class CalculateStandardPayment
extends EvaluatingCalculationRule<DeductibleLine, ServiceLinePaymentData, DeductibleLineContext> {
    public CalculateStandardPayment(List<CalculationRule<DeductibleLine, ServiceLinePaymentData, DeductibleLineContext>> calculationRules) {
        super(calculationRules);
    }

    private static boolean hasPayableStatus(String paymentIndicator) {
        return Stream.of(PaymentIndicator.PAID_STANDARD_HOSPITAL_OPPS_AMOUNT_1, PaymentIndicator.PAID_STANDARD_AMOUNT_FOR_PASS_THROUGH_DRUG_OR_BIOLOGICAL_5, PaymentIndicator.PAYMENT_BASED_ON_CHARGE_ADJUSTED_TO_COST_6, PaymentIndicator.ADDITIONAL_PAYMENT_FOR_NEW_DRUG_OR_BIOLOGICAL_7, PaymentIndicator.PAID_PARTIAL_HOSPITALIZATION_PER_DIEM_8).anyMatch(pi -> pi.is(paymentIndicator));
    }

    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        String paymentIndicator = ((DeductibleLine)calculationContext.getInput()).getServiceLine().getPaymentIndicator();
        if (CalculateStandardPayment.hasPayableStatus(paymentIndicator)) {
            super.calculate(calculationContext);
        } else {
            calculationContext.setCalculationCompleted();
        }
    }
}

