/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_claim;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.api.v2.OppsPaymentData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public class DetermineCbsa
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        String psfCbsa;
        OutpatientProviderData providerData = calculationContext.getProviderData();
        OppsPaymentData paymentData = calculationContext.getPaymentData();
        String specialPaymentIndicator = providerData.getSpecialPaymentIndicator();
        LocalDate serviceFromDate = calculationContext.getClaimData().getServiceFromDate();
        if (StringUtils.equalsAny(specialPaymentIndicator, "D", "Y")) {
            psfCbsa = providerData.getCbsaWageIndexLocation();
        } else if (StringUtils.isEmpty(StringUtils.trimToEmpty(specialPaymentIndicator))) {
            psfCbsa = providerData.getCbsaActualGeographicLocation();
        } else {
            if (StringUtils.equalsAny(specialPaymentIndicator, "1", "2") && providerData.getEffectiveDate().getYear() == serviceFromDate.getYear() && providerData.getSpecialWageIndex() != null) {
                paymentData.setFinalCbsa(providerData.getCbsaActualGeographicLocation());
                calculationContext.setWageIndex(providerData.getSpecialWageIndex());
                return;
            }
            calculationContext.applyClaimReturnCode(ReturnCode.WAGE_INDEX_INVALID_RECLASSIFICATION_52);
            return;
        }
        if (psfCbsa == null || psfCbsa.trim().isEmpty()) {
            calculationContext.applyClaimReturnCode(ReturnCode.WAGE_INDEX_INVALID_RECLASSIFICATION_52);
            return;
        }
        paymentData.setFinalCbsa(psfCbsa);
    }
}

