/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_claim;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class WageIndexTransitionAdjustment
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        String providerNumber = calculationContext.getProviderData().getProviderCcn();
        String truncatedProviderNumber = StringUtils.truncate(providerNumber, 6);
        BigDecimal wageIndex = calculationContext.getWageIndex();
        BigDecimal previousWageIndex = calculationContext.getDataTables().getPriorYearWageIndex(truncatedProviderNumber);
        if (previousWageIndex == null) {
            calculationContext.applyClaimReturnCode(ReturnCode.WAGE_INDEX_NOT_FOUND_50);
            return;
        }
        if (BigDecimalUtils.isZero(previousWageIndex)) {
            return;
        }
        if (BigDecimalUtils.isGreaterThan(calculationContext.getWageIndexPercentReduction(), wageIndex.subtract(previousWageIndex).divide(previousWageIndex, RoundingMode.HALF_UP))) {
            calculationContext.setWageIndex(previousWageIndex.multiply(calculationContext.getWageIndexPercentAdjustment()).setScale(4, RoundingMode.HALF_UP));
        }
    }
}

