/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.tables;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize(builder=ApcRateHistoryEntryBuilder.class)
@JsonPropertyOrder(value={"apc", "statusIndicator", "effectiveDate", "paymentRate", "nationalCoinsurance", "minimumCoinsurance"})
@Immutable
public class ApcRateHistoryEntry {
    private static final BigDecimal PERCENT_100 = new BigDecimal("1.0").setScale(9, RoundingMode.UNNECESSARY);
    private static final BigDecimal PERCENT_80 = new BigDecimal(".8").setScale(9, RoundingMode.UNNECESSARY);
    private static final BigDecimal PERCENT_75 = new BigDecimal(".75").setScale(9, RoundingMode.UNNECESSARY);
    @Pattern(regexp="0\\d{4}")
    private final @Pattern(regexp="0\\d{4}") String apc;
    @Pattern(regexp="\\w\\w?")
    private final @Pattern(regexp="\\w\\w?") String statusIndicator;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
    private final LocalDate effectiveDate;
    @Digits(integer=6, fraction=2)
    @DecimalMin(value="0.0")
    @DecimalMax(value="999999.99")
    @BigDecimalScale
    private final @Digits(integer=6, fraction=2) @DecimalMin(value="0.0") @DecimalMax(value="999999.99") BigDecimal paymentRate;
    @Digits(integer=5, fraction=2)
    @DecimalMin(value="0.0")
    @DecimalMax(value="99999.99")
    @BigDecimalScale
    private final @Digits(integer=5, fraction=2) @DecimalMin(value="0.0") @DecimalMax(value="99999.99") BigDecimal nationalCoinsurance;
    @Digits(integer=5, fraction=2)
    @DecimalMin(value="0.0")
    @DecimalMax(value="99999.99")
    @BigDecimalScale
    private final @Digits(integer=5, fraction=2) @DecimalMin(value="0.0") @DecimalMax(value="99999.99") BigDecimal minimumCoinsurance;
    @JsonIgnore
    private final Integer rank;

    @JsonIgnore
    public final BigDecimal getReimbursementPercent() {
        return this.calculateReimbursementRate().setScale(6, RoundingMode.HALF_UP);
    }

    @JsonIgnore
    public final BigDecimal getReimbursementRanking() {
        return this.calculateReimbursementRate();
    }

    @JsonIgnore
    private BigDecimal calculateReimbursementRate() {
        if (this.statusIndicator.contains(StatusIndicator.H1_NON_OPIOID_MEDICAL_DEVICE.getIndicator())) {
            return PERCENT_80;
        }
        if (this.paymentRate == null || BigDecimalUtils.isZero(this.paymentRate)) {
            return PERCENT_100;
        }
        if (StringUtils.equalsAny(this.apc, "00158", "00159")) {
            return PERCENT_75;
        }
        if (BigDecimalUtils.isZero(this.getNationalCoinsurance())) {
            return PERCENT_100;
        }
        if (BigDecimalUtils.equals(this.getNationalCoinsurance(), this.paymentRate.multiply(new BigDecimal(".2")).setScale(2, RoundingMode.HALF_UP))) {
            return PERCENT_80;
        }
        return BigDecimal.ONE.subtract(this.getNationalCoinsurance().divide(this.paymentRate, 9, RoundingMode.HALF_UP));
    }

    public ApcRateHistoryEntryBuilder copyBuilder() {
        return ApcRateHistoryEntry.builder().apc(this.getApc()).statusIndicator(this.getStatusIndicator()).effectiveDate(this.getEffectiveDate()).paymentRate(this.getPaymentRate()).nationalCoinsurance(this.getNationalCoinsurance()).minimumCoinsurance(this.getMinimumCoinsurance()).rank(this.getRank());
    }

    @Generated
    ApcRateHistoryEntry(String apc, String statusIndicator, LocalDate effectiveDate, BigDecimal paymentRate, BigDecimal nationalCoinsurance, BigDecimal minimumCoinsurance, Integer rank) {
        this.apc = apc;
        this.statusIndicator = statusIndicator;
        this.effectiveDate = effectiveDate;
        this.paymentRate = paymentRate;
        this.nationalCoinsurance = nationalCoinsurance;
        this.minimumCoinsurance = minimumCoinsurance;
        this.rank = rank;
    }

    @Generated
    public static ApcRateHistoryEntryBuilder builder() {
        return new ApcRateHistoryEntryBuilder();
    }

    @Generated
    public String getApc() {
        return this.apc;
    }

    @Generated
    public String getStatusIndicator() {
        return this.statusIndicator;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public BigDecimal getPaymentRate() {
        return this.paymentRate;
    }

    @Generated
    public BigDecimal getNationalCoinsurance() {
        return this.nationalCoinsurance;
    }

    @Generated
    public BigDecimal getMinimumCoinsurance() {
        return this.minimumCoinsurance;
    }

    @Generated
    public Integer getRank() {
        return this.rank;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class ApcRateHistoryEntryBuilder {
        @Generated
        private String apc;
        @Generated
        private String statusIndicator;
        @Generated
        private LocalDate effectiveDate;
        @Generated
        private BigDecimal paymentRate;
        @Generated
        private BigDecimal nationalCoinsurance;
        @Generated
        private BigDecimal minimumCoinsurance;
        @Generated
        private Integer rank;

        @Generated
        ApcRateHistoryEntryBuilder() {
        }

        @Generated
        public ApcRateHistoryEntryBuilder apc(String apc) {
            this.apc = apc;
            return this;
        }

        @Generated
        public ApcRateHistoryEntryBuilder statusIndicator(String statusIndicator) {
            this.statusIndicator = statusIndicator;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
        @Generated
        public ApcRateHistoryEntryBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Generated
        public ApcRateHistoryEntryBuilder paymentRate(BigDecimal paymentRate) {
            this.paymentRate = paymentRate;
            return this;
        }

        @Generated
        public ApcRateHistoryEntryBuilder nationalCoinsurance(BigDecimal nationalCoinsurance) {
            this.nationalCoinsurance = nationalCoinsurance;
            return this;
        }

        @Generated
        public ApcRateHistoryEntryBuilder minimumCoinsurance(BigDecimal minimumCoinsurance) {
            this.minimumCoinsurance = minimumCoinsurance;
            return this;
        }

        @JsonIgnore
        @Generated
        public ApcRateHistoryEntryBuilder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        @Generated
        public ApcRateHistoryEntry build() {
            return new ApcRateHistoryEntry(this.apc, this.statusIndicator, this.effectiveDate, this.paymentRate, this.nationalCoinsurance, this.minimumCoinsurance, this.rank);
        }

        @Generated
        public String toString() {
            return "ApcRateHistoryEntry.ApcRateHistoryEntryBuilder(apc=" + this.apc + ", statusIndicator=" + this.statusIndicator + ", effectiveDate=" + this.effectiveDate + ", paymentRate=" + this.paymentRate + ", nationalCoinsurance=" + this.nationalCoinsurance + ", minimumCoinsurance=" + this.minimumCoinsurance + ", rank=" + this.rank + ")";
        }
    }

    @Generated
    public static final class Fields {
        public static final String APC = "apc";
        public static final String STATUS_INDICATOR = "statusIndicator";
        public static final String EFFECTIVE_DATE = "effectiveDate";
        public static final String PAYMENT_RATE = "paymentRate";
        public static final String NATIONAL_COINSURANCE = "nationalCoinsurance";
        public static final String MINIMUM_COINSURANCE = "minimumCoinsurance";
        public static final String RANK = "rank";
    }
}

