/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.opps.core.tables.ApcRateHistoryEntry;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class ApcRateHistoryLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/apc-rate-%s.csv";
    private final CsvContentReader<ApcRateHistoryEntry> contentProvider = new CsvContentReader<ApcRateHistoryEntry>(ApcRateHistoryEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public ApcRateHistoryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> generate(String csvFile) {
        List content = this.contentProvider.read(csvFile).stream().sorted(Comparator.comparing(ApcRateHistoryEntry::getReimbursementRanking)).collect(Collectors.toList());
        int rank = 0;
        ArrayList<ApcRateHistoryEntry> rankedContent = new ArrayList<ApcRateHistoryEntry>();
        for (ApcRateHistoryEntry entry : content) {
            ApcRateHistoryEntry copy = entry.copyBuilder().rank(rank).build();
            rankedContent.add(copy);
            ++rank;
        }
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<ApcRateHistoryEntry, ?, NavigableMap> collector = Collectors.toMap(ApcRateHistoryEntry::getEffectiveDate, Function.identity(), comparator, TreeMap::new);
        return LookupGenerator.generateCrossReferenceToMap(ApcRateHistoryEntry::getApc, rankedContent, HashMap::new, collector);
    }
}

