/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit5;

import io.dropwizard.testing.common.DAOTest;
import io.dropwizard.testing.junit5.DropwizardExtension;
import java.util.concurrent.Callable;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class DAOTestExtension
implements DropwizardExtension,
BeforeAllCallback,
AfterAllCallback {
    private final DAOTest daoTest;

    public static Builder newBuilder() {
        return new Builder();
    }

    private DAOTestExtension(DAOTest daoTest) {
        this.daoTest = daoTest;
    }

    @Override
    public void before() throws Throwable {
        this.daoTest.before();
    }

    @Override
    public void after() {
        this.daoTest.after();
    }

    @Override
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        try {
            this.before();
        }
        catch (Throwable e) {
            throw new HibernateException(e);
        }
    }

    @Override
    public void afterAll(ExtensionContext extensionContext) {
        this.after();
    }

    public SessionFactory getSessionFactory() {
        return this.daoTest.getSessionFactory();
    }

    public <T> T inTransaction(Callable<T> call) {
        return this.daoTest.inTransaction(call);
    }

    public void inTransaction(Runnable action) {
        this.daoTest.inTransaction(action);
    }

    public static class Builder
    extends DAOTest.Builder<Builder> {
        public DAOTestExtension build() {
            return new DAOTestExtension(this.buildDAOTest());
        }
    }
}

