/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DynamicDescendantFilter;
import org.junit.jupiter.engine.descriptor.DynamicNodeTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestFactoryTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

class DynamicContainerTestDescriptor
extends DynamicNodeTestDescriptor {
    private final DynamicContainer dynamicContainer;
    private final TestSource testSource;
    private final DynamicDescendantFilter dynamicDescendantFilter;

    DynamicContainerTestDescriptor(UniqueId uniqueId, int index, DynamicContainer dynamicContainer, TestSource testSource, DynamicDescendantFilter dynamicDescendantFilter, JupiterConfiguration configuration) {
        super(uniqueId, index, dynamicContainer, testSource, configuration);
        this.dynamicContainer = dynamicContainer;
        this.testSource = testSource;
        this.dynamicDescendantFilter = dynamicDescendantFilter;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        AtomicInteger index = new AtomicInteger(1);
        try (Stream<? extends DynamicNode> children = this.dynamicContainer.getChildren();){
            children.map(child -> {
                Preconditions.notNull(child, "individual dynamic node must not be null");
                return this.toDynamicDescriptor(index.getAndIncrement(), (DynamicNode)child);
            }).filter(Optional::isPresent).map(Optional::get).forEachOrdered(arg_0 -> ((Node.DynamicTestExecutor)dynamicTestExecutor).execute(arg_0));
        }
        return context;
    }

    private Optional<JupiterTestDescriptor> toDynamicDescriptor(int index, DynamicNode childNode) {
        return TestFactoryTestDescriptor.createDynamicDescriptor(this, childNode, index, this.testSource, this.dynamicDescendantFilter, this.configuration);
    }
}

