/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.resources;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import gov.cms.fiss.pricers.common.api.CbsaWageIndexData;
import gov.cms.fiss.pricers.common.api.CbsaWageIndexResponse;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.OpenApiApplicationConfiguration;
import gov.cms.fiss.pricers.common.application.Rfc7807Support;
import gov.cms.fiss.pricers.common.application.resources.BaseRetrievalResource;
import gov.cms.fiss.pricers.common.application.resources.CbsaTableEntryCsvFormatter;
import io.dropwizard.jersey.jsr310.LocalDateParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.time.LocalDate;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.commons.lang3.ObjectUtils;

@Path(value="/v1/cbsa-wage-indexes")
public class CbsaWageIndexResource
extends BaseRetrievalResource<CbsaWageIndexData, CbsaWageIndexResponse> {
    public CbsaWageIndexResource(OpenApiApplicationConfiguration pricerConfiguration, IntFunction<List<CbsaWageIndexData>> extractionFunction) {
        super(pricerConfiguration, () -> (CsvMapper)DEFAULT_CSV_MAPPER.copy().addMixIn(CbsaWageIndexData.class, CbsaTableEntryCsvFormatter.class), csvMapper -> CsvSchema.builder().addColumn("cbsa").addColumn("size").addColumn("effectiveDate", CsvSchema.ColumnType.STRING).addColumn("geographicWageIndex", CsvSchema.ColumnType.NUMBER).addColumn("reclassifiedWageIndex", CsvSchema.ColumnType.NUMBER).addColumn("ruralFloorWageIndex", CsvSchema.ColumnType.NUMBER).addColumn("imputedFloorWageIndex", CsvSchema.ColumnType.NUMBER).addColumn("name").build().withHeader(), CbsaWageIndexResponse::new, extractionFunction);
    }

    @GET
    @Operation(summary="Retrieves all wage index data for a given fiscal year.", description="Retrieves all CBSA wage index data for all effective dates within the provided fiscal year.", responses={@ApiResponse(responseCode="200", description="The matching CBSA data", content={@Content(mediaType="application/json", schema=@Schema(implementation=CbsaWageIndexResponse.class)), @Content(mediaType="text/csv")}), @ApiResponse(responseCode="400", description="Invalid input provided. Please correct the indicated issues and re-submit your request.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error related to the parsing failure.", name="fieldValidationFailure", summary="Invalid request content.", value="{\n    \"status\": 400,\n    \"violations\": [\n        {\n            \"field\": \"findAll.path param year\",\n            \"message\": \"must be greater than or equal to 2000\"\n        }\n    ],\n    \"title\": \"Constraint Violation\"\n}")})}), @ApiResponse(responseCode="404", description="Resource not found.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs if the requested resource doesn't exist.", name="missingResource", summary="Resource not found.", value="{\n    \"title\": \"Not Found\",\n    \"status\": 404,\n    \"detail\": \"Year not in supported list.\"\n}")})}), @ApiResponse(responseCode="406", description="Occurs when media type requested isn't supported.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs media type requested isn't supported.", name="unsupportedMediaType", summary="An unsupported media type was requested.", value="{\n    \"title\": \"Not Acceptable\",\n    \"status\": 406,\n    \"detail\": \"*/* not supported. Must be one of: application/json, text/csv\"\n}")})}), @ApiResponse(responseCode="500", description="Internal pricer error. This is usually the result of an internal issue that the client cannot resolve.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error information.", name="internalServerError", summary="Internal processing error", value="{\n    \"title\": \"Internal Pricer Exception\",\n    \"status\": 500,\n    \"detail\": \"Null pointer exception\",\n    \"errorMessage\": \"Unexpected exception while executing pricer\"\n}")})})})
    @Path(value="{year}")
    @Produces(value={"application/json", "text/csv"})
    @Rfc7807Support
    @Timed
    public Response getAllForYear(@Max(value=9999L) @Min(value=2000L) @NotNull @PathParam(value="year") @Parameter(description="The fiscal year for which data will be retrieved.") @Max(value=9999L) @Min(value=2000L) @NotNull int year, @HeaderParam(value="Accept") String contentType) throws YearNotImplementedException {
        return this.getPerYearEntries(year, contentType);
    }

    @GET
    @Operation(summary="Retrieve all matching CBSA data for a given year.", description="Returns the data for a specific CBSA for matching effective dates within the provided fiscal year.", responses={@ApiResponse(responseCode="200", description="The matching CBSA data", content={@Content(mediaType="application/json", schema=@Schema(implementation=CbsaWageIndexResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input provided. Please correct the indicated issues and re-submit your request.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error related to the parsing failure.", name="fieldValidationFailure", summary="Invalid request content.", value="{\n    \"status\": 400,\n    \"violations\": [\n        {\n            \"field\": \"findAll.path param year\",\n            \"message\": \"must be greater than or equal to 2000\"\n        }\n    ],\n    \"title\": \"Constraint Violation\"\n}")})}), @ApiResponse(responseCode="404", description="Resource not found.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs if the requested resource doesn't exist.", name="missingResource", summary="Resource not found.", value="{\n    \"title\": \"Not Found\",\n    \"status\": 404,\n    \"detail\": \"Year not in supported list.\"\n}")})}), @ApiResponse(responseCode="406", description="Occurs when media type requested isn't supported.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs media type requested isn't supported.", name="unsupportedMediaType", summary="An unsupported media type was requested.", value="{\n    \"title\": \"Not Acceptable\",\n    \"status\": 406,\n    \"detail\": \"*/* not supported. Must be one of: application/json, text/csv\"\n}")})}), @ApiResponse(responseCode="500", description="Internal pricer error. This is usually the result of an internal issue that the client cannot resolve.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error information.", name="internalServerError", summary="Internal processing error", value="{\n    \"title\": \"Internal Pricer Exception\",\n    \"status\": 500,\n    \"detail\": \"Null pointer exception\",\n    \"errorMessage\": \"Unexpected exception while executing pricer\"\n}")})})})
    @Path(value="{year}/{geolocation}")
    @Produces(value={"application/json"})
    @Rfc7807Support
    @Timed
    public Response getByCodeForYear(@Max(value=9999L) @Min(value=2000L) @NotNull @Parameter(description="The fiscal year for which data will be retrieved.") @PathParam(value="year") @Max(value=9999L) @Min(value=2000L) @NotNull int year, @NotNull @Parameter(description="The CBSA geolocation for which data will be retrieved.") @PathParam(value="geolocation") @Pattern(regexp="\\d{2}|[1-9]\\d{4}", message="must be either 2 or 5 digits") @NotNull @Pattern(regexp="\\d{2}|[1-9]\\d{4}", message="must be either 2 or 5 digits") String geolocation, @Parameter(description="Filters data so that only the CBSA data effective as of the provided date will be returned; if omitted, all values for the year will be returned.", example="2020-04-01", schema=@Schema(implementation=LocalDate.class)) @QueryParam(value="effectiveDate") LocalDateParam effectiveDate) throws YearNotImplementedException {
        return super.findExactMatch(year, geolocation, effectiveDate);
    }

    @GET
    @Operation(summary="Retrieve all matching CBSA data within the given date range.", description="Returns the data for a specific CBSA within the given date range.", responses={@ApiResponse(responseCode="200", description="The matching CBSA data", content={@Content(mediaType="application/json", schema=@Schema(implementation=CbsaWageIndexResponse.class))}), @ApiResponse(responseCode="400", description="Invalid input provided. Please correct the indicated issues and re-submit your request.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error related to the parsing failure.", name="fieldValidationFailure", summary="Invalid request content.", value="{\n    \"status\": 400,\n    \"violations\": [\n        {\n            \"field\": \"findAll.path param year\",\n            \"message\": \"must be greater than or equal to 2000\"\n        }\n    ],\n    \"title\": \"Constraint Violation\"\n}")})}), @ApiResponse(responseCode="404", description="Resource not found.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs if the requested resource doesn't exist.", name="missingResource", summary="Resource not found.", value="{\n    \"title\": \"Not Found\",\n    \"status\": 404,\n    \"detail\": \"Year not in supported list.\"\n}")})}), @ApiResponse(responseCode="406", description="Occurs when media type requested isn't supported.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="Occurs media type requested isn't supported.", name="unsupportedMediaType", summary="An unsupported media type was requested.", value="{\n    \"title\": \"Not Acceptable\",\n    \"status\": 406,\n    \"detail\": \"*/* not supported. Must be one of: application/json, text/csv\"\n}")})}), @ApiResponse(responseCode="500", description="Internal pricer error. This is usually the result of an internal issue that the client cannot resolve.", content={@Content(mediaType="application/problem+json", examples={@ExampleObject(description="The error information.", name="internalServerError", summary="Internal processing error", value="{\n    \"title\": \"Internal Pricer Exception\",\n    \"status\": 500,\n    \"detail\": \"Null pointer exception\",\n    \"errorMessage\": \"Unexpected exception while executing pricer\"\n}")})})})
    @Path(value="find-in-range/{geolocation}")
    @Produces(value={"application/json"})
    @Rfc7807Support
    @Timed
    public Response findByCode(@NotNull @Parameter(description="The CBSA geolocation for which data will be retrieved.", example="10353") @PathParam(value="geolocation") @Pattern(regexp="\\d{2}|[1-9]\\d{4}", message="must be either 2 or 5 digits") @NotNull @Pattern(regexp="\\d{2}|[1-9]\\d{4}", message="must be either 2 or 5 digits") String geolocation, @Parameter(description="The maximum number of entries to return for this CBSA. Defaults to 1.", example="1") @QueryParam(value="limit") @Max(value=20L) @Min(value=1L) @Max(value=20L) @Min(value=1L) Integer limit, @Parameter(description="Filter data so that only data after the date given will be returned. By default, the provided date is included in the search. Defaults to the beginning of the earliest supported pricer year.", example="2020-04-01", schema=@Schema(implementation=LocalDate.class)) @QueryParam(value="after") LocalDateParam afterDate, @Parameter(description="Filter data so that only data before the date given will be returned. By default, the provided date is included in the search. Defaults to the current date.", example="2020-04-01", schema=@Schema(implementation=LocalDate.class)) @QueryParam(value="before") LocalDateParam beforeDate, @Parameter(description="Indicates whether the after date should be exclusive. Defaults to false.", example="false") @QueryParam(value="exclusiveAfter") Boolean exclusiveAfter, @Parameter(description="Indicates whether the before date should be exclusive. Defaults to false.", example="false") @QueryParam(value="exclusiveBefore") Boolean exclusiveBefore) {
        return super.findByCodeAndDateRange(geolocation, ObjectUtils.defaultIfNull(limit, 1), afterDate, beforeDate, ObjectUtils.defaultIfNull(exclusiveAfter, false), ObjectUtils.defaultIfNull(exclusiveBefore, false));
    }

    @Override
    protected LocalDate getDate(CbsaWageIndexData entry) {
        return entry.getEffectiveDate();
    }

    @Override
    protected String getKey(CbsaWageIndexData entry) {
        return entry.getCbsa();
    }
}

