/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.codes;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum ReturnCode {
    NOT_PROCESSED_0(0, "LINE NOT PROCESSED", "Line not processed"),
    PROCESSED_1(1, "PROCESSED", "Processed"),
    CMHC_LIMIT_REACHED_2(2, "CMHC LIMIT REACHED", "CMHC limit reached"),
    ABSENT_QUALITY_REPORTING_11(11, "ABSENT QUALITY REPORTING", "Absent quality reporting"),
    PAYMENT_EQUALS_ZERO_20(20, "PAYMENT EQUALS ZERO", "Payment equals zero"),
    DAILY_COINSURANCE_LIMITATION_22(22, "DAILY COINSURANCE LIMITATION", "Daily coinsurance limitation"),
    COINSURANCE_REDUCTION_25(25, "COINSURANCE REDUCTION", "Coinsurance reduction"),
    APC_NOT_FOUND_30(30, "APC NOT FOUND", "APC not found"),
    DISCOUNT_FACTOR_INDICATOR_INVALID_38(38, "DISCOUNT FACTOR INDICATOR INVALID", "Discount factor indicator invalid"),
    STATUS_INDICATOR_INVALID_40(40, "STATUS INDICATOR INVALID", "Status indicator invalid"),
    STATUS_INDICATOR_INVALID_FOR_OPPS_41(41, "STATUS INDICATOR INVALID FOR OPPS", "Status indicator invalid for OPPS"),
    INVALID_APC_OR_PACKAGING_FLAG_42(42, "INVALID APC OR PACKAGING FLAG", "APC equal to '00000' OR Packaging Flag = '1' or '2' or '4'"),
    INVALID_PAYMENT_INDICATOR_43(43, "INVALID PAYMENT INDICATOR", "Payment Indicator not equal to 1 or 5 thru 9"),
    INVALID_STATUS_INDICATOR_44(44, "INVALID STATUS INDICATOR", "Service Indicator equal to 'H' but Payment Indicator not equal to '6'"),
    PACKAGING_FLAG_NOT_ZERO_45(45, "PACKAGING FLAG NOT ZERO", "Packaging flag not zero"),
    INVALID_DENIAL_46(46, "INVALID DENIAL", "Line Item Denial/Reject Flag not equal zero AND Line Item Action Flag not equal to 1"),
    INVALID_ACTION_FLAG_47(47, "INVALID ACTION FLAG", "Invalid action flag"),
    INVALID_PAYMENT_ADJUSTMENT_FLAG_48(48, "INVALID PAYMENT ADJUSTMENT FLAG", "Invalid payment adjustment flag"),
    BILL_INCLUSION_FLAG_NOT_ZERO_49(49, "BILL INCLUSION FLAG NOT ZERO", "Bill inclusion flag not zero"),
    WAGE_INDEX_NOT_FOUND_50(50, "WAGE INDEX NOT FOUND", "Wage index not found"),
    WAGE_INDEX_EQUALS_ZERO_51(51, "WAGE INDEX EQUALS ZERO", "Wage index equals zero"),
    WAGE_INDEX_INVALID_RECLASSIFICATION_52(52, "WAGE INDEX INVALID RECLASSIFICATION", "Wage index invalid reclassification"),
    SERVICE_FROM_DATE_NOT_NUMERIC_53(53, "SERVICE FROM DATE NOT NUMERIC", "Service from date not numeric"),
    SERVICE_FROM_DATE_NOT_IN_RANGE_54(54, "SERVICE FROM DATE NOT IN RANGE", "Service from date not in range");

    private final int code;
    private final String desc;
    private final String exp;

    private ReturnCode(int code, String desc, String exp) {
        this.code = code;
        this.desc = desc;
        this.exp = exp;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getExplanation() {
        return this.exp;
    }

    public ReturnCodeData toReturnCodeData() {
        ReturnCodeData returnCodeData = new ReturnCodeData();
        String paddedCode = StringUtils.leftPad(Integer.toString(this.getCode()), 2, "0");
        returnCodeData.setCode(paddedCode);
        returnCodeData.setDescription(this.getDescription());
        returnCodeData.setExplanation(this.getExplanation());
        return returnCodeData;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public String getExp() {
        return this.exp;
    }
}

