/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.PackageFlag;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import java.math.BigDecimal;
import java.util.stream.Stream;

public class AdjustLineCharges
implements CalculationRule<DeductibleLine, ServiceLinePaymentData, DeductibleLineContext> {
    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        boolean packagedBloodDeductibleLineFlag;
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        IoceServiceLineData lineInput = ((DeductibleLine)calculationContext.getInput()).getServiceLine();
        LineCalculation lineCalculation = calculationContext.getLineCalculation();
        DeductibleLine deductibleLine = lineCalculation.getDeductibleLine();
        boolean comprehensiveApcClaimFlag = pricerContext.getComprehensiveApcClaimStatus();
        String statusIndicator = lineInput.getStatusIndicator();
        String packageFlag = lineInput.getPackageFlag();
        boolean bl = packagedBloodDeductibleLineFlag = OppsPricerContext.isComprehensiveBloodDeductible(statusIndicator, lineInput.getPaymentAdjustmentFlags(), comprehensiveApcClaimFlag) && pricerContext.getDataTables().isBloodHcpcsDeductible(lineInput.getHcpcsCode());
        if (OppsPricerContext.isSignificantProcedure(statusIndicator, lineInput.getHcpcsCode())) {
            if (BigDecimalUtils.isLessThan(deductibleLine.getSubCharge(), new BigDecimal("1.01"))) {
                pricerContext.setSt0Flag(true);
            }
            if (this.isArtificialOrNotPackaged(packageFlag)) {
                pricerContext.setTotalSTCharge(pricerContext.getTotalSTCharge().add(deductibleLine.getSubCharge()));
                pricerContext.setTotalSTPayment(pricerContext.getTotalSTPayment().add(lineCalculation.getPayment()));
            }
        }
        if (OppsPricerContext.isSeparatelyPayable(statusIndicator) && this.isArtificialOrNotPackaged(packageFlag) && !packagedBloodDeductibleLineFlag) {
            pricerContext.setTotalSTVXPayment(pricerContext.getTotalSTVXPayment().add(lineCalculation.getPayment()));
        }
    }

    private boolean isArtificialOrNotPackaged(String packageFlag) {
        return Stream.of(PackageFlag.NOT_PACKAGED_0, PackageFlag.ARTIFICIAL_SURGICAL_3).anyMatch(pf -> pf.is(packageFlag));
    }
}

