/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.AbstractDeductibleLineRule;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class AdjustMinimumCoinsurance
extends AbstractDeductibleLineRule {
    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        LineCalculation lineCalculation = calculationContext.getLineCalculation();
        IoceServiceLineData lineInput = lineCalculation.getLineInput();
        DeductibleLine deductibleLine = lineCalculation.getDeductibleLine();
        lineCalculation.setMinimumCoinsurance(deductibleLine.getMinimumCoinsurance());
        if (BigDecimalUtils.isGreaterThanZero(deductibleLine.getMinimumCoinsurance())) {
            if (this.isPassThroughDeviceOrBloodProductOrBrachytherapy(lineInput.getStatusIndicator())) {
                lineCalculation.setMinimumCoinsurance(lineCalculation.getMinimumCoinsurance().multiply(new BigDecimal(deductibleLine.getServiceUnits()).subtract(new BigDecimal(deductibleLine.getServiceUnits()).multiply(lineCalculation.getBloodFraction()))).multiply(deductibleLine.getDiscountRate()).setScale(2, RoundingMode.HALF_UP));
            } else if (this.isColorectalCancerScreening(lineInput.getPaymentApc())) {
                lineCalculation.setMinimumCoinsurance(lineCalculation.getPayment().multiply(new BigDecimal(".25")).setScale(2, RoundingMode.HALF_UP));
            } else {
                lineCalculation.setMinimumCoinsurance(lineCalculation.getPayment().multiply(new BigDecimal(".20")).setScale(2, RoundingMode.HALF_UP));
            }
        }
    }

    private boolean isPassThroughDeviceOrBloodProductOrBrachytherapy(String statusIndicator) {
        return Stream.of(StatusIndicator.H_PASS_THROUGH_DEVICE, StatusIndicator.R_BLOOD, StatusIndicator.U_BRACHYTHERAPY).anyMatch(si -> si.is(statusIndicator));
    }

    private boolean isColorectalCancerScreening(String apc) {
        return StringUtils.equalsAny(apc, "00158", "00159");
    }
}

