/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.coinsurance_and_reimbursement_calculation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.core.CoinsuranceCapContext;
import gov.cms.fiss.pricers.opps.core.model.CoinsuranceCapEntry;
import gov.cms.fiss.pricers.opps.core.model.CoinsuranceCapValues;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateBloodCoinsuranceToBePaid
implements CalculationRule<CoinsuranceCapEntry, CoinsuranceCapValues, CoinsuranceCapContext> {
    @Override
    public void calculate(CoinsuranceCapContext calculationContext) {
        CoinsuranceCapEntry entry = (CoinsuranceCapEntry)calculationContext.getInput();
        CoinsuranceCapValues lastReturn = (CoinsuranceCapValues)calculationContext.getOutput();
        if (entry.getCode() == 1) {
            if (BigDecimalUtils.isGreaterThanZero(entry.getCoinsurance2())) {
                lastReturn.setLastCoinsuranceDateOfService(entry.getDateOfService());
                lastReturn.setTotal(entry.getCoinsurance1());
                lastReturn.setRatio(calculationContext.getPricerContext().getInpatientDeductibleLimit().subtract(entry.getCoinsurance1()).divide(entry.getCoinsurance2(), 7, RoundingMode.DOWN));
                if (BigDecimalUtils.isLessThanZero(lastReturn.getRatio())) {
                    lastReturn.setRatio(BigDecimalUtils.ZERO);
                }
            }
            if (BigDecimalUtils.isGreaterThan(lastReturn.getRatio(), BigDecimal.ONE)) {
                lastReturn.setRatio(BigDecimal.ONE);
            }
        }
    }
}

