/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_claim;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.tables.CbsaWageIndexEntry;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;

public class WageIndexLookupAndFloor
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        OutpatientProviderData providerData = calculationContext.getProviderData();
        String specialPaymentIndicator = providerData.getSpecialPaymentIndicator();
        BigDecimal stateFloorWageIndex = this.getWageIndexByState(calculationContext);
        CbsaWageIndexEntry cbsaWageIndexEntry = this.getWageIndexEntryByCbsa(calculationContext);
        if (cbsaWageIndexEntry == null) {
            return;
        }
        if ("Y".equals(specialPaymentIndicator)) {
            calculationContext.setWageIndex(stateFloorWageIndex.max(cbsaWageIndexEntry.getReclassifiedWageIndex()));
        } else {
            calculationContext.setWageIndex(stateFloorWageIndex.max(cbsaWageIndexEntry.getGeographicWageIndex()));
        }
    }

    private BigDecimal getWageIndexByState(OppsPricerContext context) {
        String stateCode = context.getProviderData().getStateCode();
        LocalDate serviceDate = context.getClaimData().getServiceFromDate();
        NavigableMap<LocalDate, CbsaWageIndexEntry> wageIndices = context.getDataTables().getCbsaWageIndexEntries(stateCode);
        if (wageIndices == null) {
            return BigDecimal.ZERO;
        }
        CbsaWageIndexEntry entry = this.lookupWageIndex(wageIndices, serviceDate);
        return entry == null ? BigDecimalUtils.ZERO : entry.getRuralFloorWageIndex();
    }

    private CbsaWageIndexEntry getWageIndexEntryByCbsa(OppsPricerContext context) {
        String cbsa = context.getPaymentData().getFinalCbsa();
        LocalDate serviceDate = ((OppsClaimData)((OppsClaimPricingRequest)context.getInput()).getClaimData()).getServiceFromDate();
        NavigableMap<LocalDate, CbsaWageIndexEntry> wageIndices = context.getDataTables().getCbsaWageIndexEntries(cbsa);
        if (wageIndices == null) {
            context.applyClaimReturnCode(ReturnCode.WAGE_INDEX_NOT_FOUND_50);
            return null;
        }
        CbsaWageIndexEntry wageIndexEntry = this.lookupWageIndex(wageIndices, serviceDate);
        if (wageIndexEntry == null) {
            context.applyClaimReturnCode(ReturnCode.WAGE_INDEX_EQUALS_ZERO_51);
            return null;
        }
        return wageIndexEntry;
    }

    protected CbsaWageIndexEntry lookupWageIndex(NavigableMap<LocalDate, CbsaWageIndexEntry> wageIndices, LocalDate serviceDate) {
        Map.Entry<LocalDate, CbsaWageIndexEntry> entry = wageIndices.floorEntry(serviceDate);
        if (entry == null) {
            return null;
        }
        CbsaWageIndexEntry wageIndexEntry = entry.getValue().copyBuilder().build();
        if (wageIndexEntry.getEffectiveDate().getYear() == serviceDate.getYear()) {
            return wageIndexEntry;
        }
        return null;
    }
}

